@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Machine assessment resource.
 * @property assessmentErrorSummary Gets or sets the assessment error summary.
 *             This is the number of
 * machines affected by each type of error in this assessment.
 * @property assessmentType Assessment type of the assessment.
 * @property azureDiskTypes Gets or sets the azure storage type. Premium, Standard etc.
 * @property azureHybridUseBenefit Gets or sets the user configurable setting to display the azure hybrid use
 * benefit.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azurePricingTier Gets or sets Azure Pricing Tier - Free, Basic, etc.
 * @property azureStorageRedundancy Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
 * @property azureVmFamilies Gets or sets the Azure VM families.
 * @property confidenceRatingInPercentage Confidence Rating in Percentage.
 * @property costComponents Gets the collection of cost components.
 * @property createdTimestamp Date and Time when assessment was created.
 * @property currency Currency in which prices should be reported.
 * @property discountPercentage Custom discount percentage.
 * @property distributionByOsName Gets the distribution by os name.
 * @property distributionByServicePackInsight Gets the distribution distribution of sqlInstances by service pack insight.
 * @property distributionBySupportStatus Gets the distribution of sqlInstances by support status.
 * @property eaSubscriptionId Gets or sets enterprise agreement subscription id.
 * @property groupType Gets the group type for the assessment.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property linuxAzureHybridUseBenefit Gets or sets the user configurable setting to display the linux azure hybrid use
 * benefit.
 * @property monthlyBandwidthCost Gets or sets the aggregate Bandwidth Cost for all machines in the assessment.
 * @property monthlyComputeCost Gets or sets the aggregate Compute Cost for all machines in the assessment.
 * @property monthlyPremiumStorageCost Gets or sets the aggregate premium storage cost for all machines in the
 * assessment.
 * @property monthlyStandardSsdStorageCost Gets or sets the aggregate standard SSD storage cost for all the machines in
 * the assessment.
 * @property monthlyStorageCost Gets or sets the aggregate Storage Cost for all machines in the assessment.
 * @property monthlyUltraStorageCost Gets or sets the aggregate ultra storage cost for all machines in the
 * assessment.
 * @property name The name of the resource
 * @property numberOfMachines Gets or sets the Number of machines part of the assessment.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property pricesTimestamp Last time when rates were queried.
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property schemaVersion Schema version.
 * @property sizingCriterion Assessment sizing criterion.
 * @property stage User configurable setting to display the Stage of Assessment.
 * @property status Whether assessment is in valid state and all machines have been assessed.
 * @property suitabilitySummary Gets or sets the Cloud suitability summary for all the machines in the
 * assessment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Date and Time when assessment was last updated.
 * @property vmUptime Gets or sets the duration for which the VMs are up in the on-premises
 * environment.
 */
public data class GetAssessmentsOperationResult(
    public val assessmentErrorSummary: Map<String, Int>,
    public val assessmentType: String,
    public val azureDiskTypes: List<String>? = null,
    public val azureHybridUseBenefit: String? = null,
    public val azureLocation: String? = null,
    public val azureOfferCode: String? = null,
    public val azurePricingTier: String? = null,
    public val azureStorageRedundancy: String? = null,
    public val azureVmFamilies: List<String>? = null,
    public val confidenceRatingInPercentage: Double,
    public val costComponents: List<CostComponentResponse>,
    public val createdTimestamp: String,
    public val currency: String? = null,
    public val discountPercentage: Double? = null,
    public val distributionByOsName: Map<String, Int>,
    public val distributionByServicePackInsight: Map<String, Int>,
    public val distributionBySupportStatus: Map<String, Int>,
    public val eaSubscriptionId: String? = null,
    public val groupType: String,
    public val id: String,
    public val linuxAzureHybridUseBenefit: String? = null,
    public val monthlyBandwidthCost: Double,
    public val monthlyComputeCost: Double,
    public val monthlyPremiumStorageCost: Double,
    public val monthlyStandardSsdStorageCost: Double,
    public val monthlyStorageCost: Double,
    public val monthlyUltraStorageCost: Double,
    public val name: String,
    public val numberOfMachines: Int,
    public val percentile: String? = null,
    public val perfDataEndTime: String? = null,
    public val perfDataStartTime: String? = null,
    public val pricesTimestamp: String,
    public val provisioningState: String? = null,
    public val reservedInstance: String? = null,
    public val scalingFactor: Double? = null,
    public val schemaVersion: String,
    public val sizingCriterion: String? = null,
    public val stage: String,
    public val status: String,
    public val suitabilitySummary: Map<String, Int>,
    public val systemData: SystemDataResponse,
    public val timeRange: String? = null,
    public val type: String,
    public val updatedTimestamp: String,
    public val vmUptime: VmUptimeResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetAssessmentsOperationResult):
            GetAssessmentsOperationResult = GetAssessmentsOperationResult(
            assessmentErrorSummary = javaType.assessmentErrorSummary().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            assessmentType = javaType.assessmentType(),
            azureDiskTypes = javaType.azureDiskTypes().map({ args0 -> args0 }),
            azureHybridUseBenefit = javaType.azureHybridUseBenefit().map({ args0 -> args0 }).orElse(null),
            azureLocation = javaType.azureLocation().map({ args0 -> args0 }).orElse(null),
            azureOfferCode = javaType.azureOfferCode().map({ args0 -> args0 }).orElse(null),
            azurePricingTier = javaType.azurePricingTier().map({ args0 -> args0 }).orElse(null),
            azureStorageRedundancy = javaType.azureStorageRedundancy().map({ args0 -> args0 }).orElse(null),
            azureVmFamilies = javaType.azureVmFamilies().map({ args0 -> args0 }),
            confidenceRatingInPercentage = javaType.confidenceRatingInPercentage(),
            costComponents = javaType.costComponents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.CostComponentResponse.Companion.toKotlin(args0)
                })
            }),
            createdTimestamp = javaType.createdTimestamp(),
            currency = javaType.currency().map({ args0 -> args0 }).orElse(null),
            discountPercentage = javaType.discountPercentage().map({ args0 -> args0 }).orElse(null),
            distributionByOsName = javaType.distributionByOsName().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            distributionByServicePackInsight = javaType.distributionByServicePackInsight().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            distributionBySupportStatus = javaType.distributionBySupportStatus().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            eaSubscriptionId = javaType.eaSubscriptionId().map({ args0 -> args0 }).orElse(null),
            groupType = javaType.groupType(),
            id = javaType.id(),
            linuxAzureHybridUseBenefit = javaType.linuxAzureHybridUseBenefit().map({ args0 ->
                args0
            }).orElse(null),
            monthlyBandwidthCost = javaType.monthlyBandwidthCost(),
            monthlyComputeCost = javaType.monthlyComputeCost(),
            monthlyPremiumStorageCost = javaType.monthlyPremiumStorageCost(),
            monthlyStandardSsdStorageCost = javaType.monthlyStandardSsdStorageCost(),
            monthlyStorageCost = javaType.monthlyStorageCost(),
            monthlyUltraStorageCost = javaType.monthlyUltraStorageCost(),
            name = javaType.name(),
            numberOfMachines = javaType.numberOfMachines(),
            percentile = javaType.percentile().map({ args0 -> args0 }).orElse(null),
            perfDataEndTime = javaType.perfDataEndTime().map({ args0 -> args0 }).orElse(null),
            perfDataStartTime = javaType.perfDataStartTime().map({ args0 -> args0 }).orElse(null),
            pricesTimestamp = javaType.pricesTimestamp(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            reservedInstance = javaType.reservedInstance().map({ args0 -> args0 }).orElse(null),
            scalingFactor = javaType.scalingFactor().map({ args0 -> args0 }).orElse(null),
            schemaVersion = javaType.schemaVersion(),
            sizingCriterion = javaType.sizingCriterion().map({ args0 -> args0 }).orElse(null),
            stage = javaType.stage(),
            status = javaType.status(),
            suitabilitySummary = javaType.suitabilitySummary().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeRange = javaType.timeRange().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
            vmUptime = javaType.vmUptime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.VmUptimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
