@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Download URL for assessment report.
 * @property businessCaseReportUrl Hyperlink to download report.
 * @property expirationTime Expiry date of download url.
 */
public data class GetBusinessCaseOperationReportDownloadUrlResult(
    public val businessCaseReportUrl: String,
    public val expirationTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetBusinessCaseOperationReportDownloadUrlResult):
            GetBusinessCaseOperationReportDownloadUrlResult =
            GetBusinessCaseOperationReportDownloadUrlResult(
                businessCaseReportUrl = javaType.businessCaseReportUrl(),
                expirationTime = javaType.expirationTime(),
            )
    }
}
