@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Define the move collection.
 * @property etag The etag of the resource.
 * @property id Fully qualified resource Id for the resource.
 * @property identity Defines the MSI properties of the Move Collection.
 * @property location The geo-location where the resource lives.
 * @property name The name of the resource
 * @property properties Defines the move collection properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetMoveCollectionResult(
    public val etag: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: MoveCollectionPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetMoveCollectionResult):
            GetMoveCollectionResult = GetMoveCollectionResult(
            etag = javaType.etag(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MoveCollectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
