@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Web app Assessment REST resource.
 * @property appSvcContainerSettings Gets or sets user configurable app service container database settings.
 * @property appSvcNativeSettings Gets or sets user configurable app service native settings.
 * @property assessmentType Assessment type of the assessment.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azureSecurityOfferingType Gets or sets a value indicating azure security offering type.
 * @property confidenceRatingInPercentage Confidence Rating in Percentage.
 * @property createdTimestamp Date and Time when assessment was created.
 * @property currency Currency in which prices should be reported.
 * @property discountPercentage Custom discount percentage.
 * @property discoveredEntityLightSummary Gets or sets user configurable discovered entity settings.
 * @property eaSubscriptionId Gets or sets the Enterprise agreement subscription id.
 * @property entityUptime Gets or sets the duration for which the entity (Web app, VMs) are up in the
 * on-premises environment.
 * @property environmentType Gets or sets user configurable setting to display the environment type.
 * @property groupType Gets the group type for the assessment.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property pricesTimestamp Last time when rates were queried.
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Reserved instance.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property schemaVersion Schema version.
 * @property sizingCriterion Assessment sizing criterion.
 * @property stage User configurable setting to display the Stage of Assessment.
 * @property status Whether assessment is in valid state and all machines have been assessed.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Date and Time when assessment was last updated.
 */
public data class GetWebAppAssessmentV2OperationResult(
    public val appSvcContainerSettings: AppSvcContainerSettingsResponse? = null,
    public val appSvcNativeSettings: AppSvcNativeSettingsResponse? = null,
    public val assessmentType: String? = null,
    public val azureLocation: String? = null,
    public val azureOfferCode: String? = null,
    public val azureSecurityOfferingType: String? = null,
    public val confidenceRatingInPercentage: Double? = null,
    public val createdTimestamp: String,
    public val currency: String? = null,
    public val discountPercentage: Double? = null,
    public val discoveredEntityLightSummary: DiscoveredEntityLightSummaryResponse? = null,
    public val eaSubscriptionId: String? = null,
    public val entityUptime: EntityUptimeResponse? = null,
    public val environmentType: String? = null,
    public val groupType: String? = null,
    public val id: String,
    public val name: String,
    public val percentile: String? = null,
    public val perfDataEndTime: String? = null,
    public val perfDataStartTime: String? = null,
    public val pricesTimestamp: String,
    public val provisioningState: String,
    public val reservedInstance: String? = null,
    public val scalingFactor: Double? = null,
    public val schemaVersion: String,
    public val sizingCriterion: String? = null,
    public val stage: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val timeRange: String? = null,
    public val type: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetWebAppAssessmentV2OperationResult):
            GetWebAppAssessmentV2OperationResult = GetWebAppAssessmentV2OperationResult(
            appSvcContainerSettings = javaType.appSvcContainerSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcContainerSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            appSvcNativeSettings = javaType.appSvcNativeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AppSvcNativeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            assessmentType = javaType.assessmentType().map({ args0 -> args0 }).orElse(null),
            azureLocation = javaType.azureLocation().map({ args0 -> args0 }).orElse(null),
            azureOfferCode = javaType.azureOfferCode().map({ args0 -> args0 }).orElse(null),
            azureSecurityOfferingType = javaType.azureSecurityOfferingType().map({ args0 ->
                args0
            }).orElse(null),
            confidenceRatingInPercentage = javaType.confidenceRatingInPercentage().map({ args0 ->
                args0
            }).orElse(null),
            createdTimestamp = javaType.createdTimestamp(),
            currency = javaType.currency().map({ args0 -> args0 }).orElse(null),
            discountPercentage = javaType.discountPercentage().map({ args0 -> args0 }).orElse(null),
            discoveredEntityLightSummary = javaType.discoveredEntityLightSummary().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DiscoveredEntityLightSummaryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eaSubscriptionId = javaType.eaSubscriptionId().map({ args0 -> args0 }).orElse(null),
            entityUptime = javaType.entityUptime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentType = javaType.environmentType().map({ args0 -> args0 }).orElse(null),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            percentile = javaType.percentile().map({ args0 -> args0 }).orElse(null),
            perfDataEndTime = javaType.perfDataEndTime().map({ args0 -> args0 }).orElse(null),
            perfDataStartTime = javaType.perfDataStartTime().map({ args0 -> args0 }).orElse(null),
            pricesTimestamp = javaType.pricesTimestamp(),
            provisioningState = javaType.provisioningState(),
            reservedInstance = javaType.reservedInstance().map({ args0 -> args0 }).orElse(null),
            scalingFactor = javaType.scalingFactor().map({ args0 -> args0 }).orElse(null),
            schemaVersion = javaType.schemaVersion(),
            sizingCriterion = javaType.sizingCriterion().map({ args0 -> args0 }).orElse(null),
            stage = javaType.stage(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeRange = javaType.timeRange().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
