@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IISWeb server.
 * @property displayName Gets or sets the display name.
 * @property ipAddresses Gets or sets list of ip addresses.
 * @property machines Gets or sets the list of machines.
 * @property operatingSystemDetails
 * @property rootConfigurationLocation Gets or sets the server root configuration location.
 * @property runAsAccountId Gets or sets the run as account id.
 * @property serverFqdn Gets or sets the server FQDN.
 * @property serverId Gets or sets the web server id.
 * @property serverName Gets or sets the web server name.
 * @property version Gets or sets the server version.
 * @property webApplications Gets or sets the list of web applications.
 */
public data class IISWebServerResponse(
    public val displayName: String? = null,
    public val ipAddresses: List<String>? = null,
    public val machines: List<String>? = null,
    public val operatingSystemDetails: OperatingSystemDetailsResponse? = null,
    public val rootConfigurationLocation: String? = null,
    public val runAsAccountId: String? = null,
    public val serverFqdn: String? = null,
    public val serverId: String? = null,
    public val serverName: String? = null,
    public val version: String? = null,
    public val webApplications: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISWebServerResponse):
            IISWebServerResponse = IISWebServerResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            machines = javaType.machines().map({ args0 -> args0 }),
            operatingSystemDetails = javaType.operatingSystemDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.OperatingSystemDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rootConfigurationLocation = javaType.rootConfigurationLocation().map({ args0 ->
                args0
            }).orElse(null),
            runAsAccountId = javaType.runAsAccountId().map({ args0 -> args0 }).orElse(null),
            serverFqdn = javaType.serverFqdn().map({ args0 -> args0 }).orElse(null),
            serverId = javaType.serverId().map({ args0 -> args0 }).orElse(null),
            serverName = javaType.serverName().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
            webApplications = javaType.webApplications().map({ args0 -> args0 }),
        )
    }
}
