@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the job status.
 * @property jobName Defines the job name.
 * @property jobProgress Gets or sets the monitoring job percentage.
 */
public data class JobStatusResponse(
    public val jobName: String,
    public val jobProgress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.JobStatusResponse):
            JobStatusResponse = JobStatusResponse(
            jobName = javaType.jobName(),
            jobProgress = javaType.jobProgress(),
        )
    }
}
