@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Labour settings.
 * @property hourlyAdminCost Hourly administrator cost.
 * @property physicalServersPerAdmin Physical servers per administrator.
 * @property virtualMachinesPerAdmin Virtual machines per administrator.
 */
public data class LaborSettingsResponse(
    public val hourlyAdminCost: Double,
    public val physicalServersPerAdmin: Int,
    public val virtualMachinesPerAdmin: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.LaborSettingsResponse):
            LaborSettingsResponse = LaborSettingsResponse(
            hourlyAdminCost = javaType.hourlyAdminCost(),
            physicalServersPerAdmin = javaType.physicalServersPerAdmin(),
            virtualMachinesPerAdmin = javaType.virtualMachinesPerAdmin(),
        )
    }
}
