@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the move resource properties.
 * @property dependsOn Gets or sets the move resource dependencies.
 * @property dependsOnOverrides Gets or sets the move resource dependencies overrides.
 * @property errors Defines the move resource errors.
 * @property existingTargetId Gets or sets the existing target ARM Id of the resource.
 * @property isResolveRequired Gets a value indicating whether the resolve action is required over the move collection.
 * @property moveStatus Defines the move resource status.
 * @property provisioningState Defines the provisioning states.
 * @property resourceSettings Gets or sets the resource settings.
 * @property sourceId Gets or sets the Source ARM Id of the resource.
 * @property sourceResourceSettings Gets or sets the source resource settings.
 * @property targetId Gets or sets the Target ARM Id of the resource.
 */
public data class MoveResourcePropertiesResponse(
    public val dependsOn: List<MoveResourceDependencyResponse>,
    public val dependsOnOverrides: List<MoveResourceDependencyOverrideResponse>? = null,
    public val errors: MoveResourcePropertiesResponseErrors,
    public val existingTargetId: String? = null,
    public val isResolveRequired: Boolean,
    public val moveStatus: MoveResourcePropertiesResponseMoveStatus,
    public val provisioningState: String,
    public val resourceSettings: Any? = null,
    public val sourceId: String,
    public val sourceResourceSettings: Any,
    public val targetId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveResourcePropertiesResponse):
            MoveResourcePropertiesResponse = MoveResourcePropertiesResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourceDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            dependsOnOverrides = javaType.dependsOnOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourceDependencyOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourcePropertiesResponseErrors.Companion.toKotlin(args0)
            }),
            existingTargetId = javaType.existingTargetId().map({ args0 -> args0 }).orElse(null),
            isResolveRequired = javaType.isResolveRequired(),
            moveStatus = javaType.moveStatus().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourcePropertiesResponseMoveStatus.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            resourceSettings = javaType.resourceSettings().map({ args0 -> args0 }).orElse(null),
            sourceId = javaType.sourceId(),
            sourceResourceSettings = javaType.sourceResourceSettings(),
            targetId = javaType.targetId(),
        )
    }
}
