@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the NSG resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/networkSecurityGroups'.
 * @property securityRules Gets or sets Security rules of network security group.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class NetworkSecurityGroupResourceSettingsResponse(
    public val resourceType: String,
    public val securityRules: List<NsgSecurityRuleResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.NetworkSecurityGroupResourceSettingsResponse):
            NetworkSecurityGroupResourceSettingsResponse = NetworkSecurityGroupResourceSettingsResponse(
            resourceType = javaType.resourceType(),
            securityRules = javaType.securityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.NsgSecurityRuleResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
        )
    }
}
