@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Defines the public IP address resource settings.
 * @property domainNameLabel Gets or sets the domain name label.
 * @property fqdn Gets or sets the fully qualified domain name.
 * @property publicIpAllocationMethod Gets or sets public IP allocation method.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/publicIPAddresses'.
 * @property sku Gets or sets public IP sku.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zones Gets or sets public IP zones.
 */
public data class PublicIPAddressResourceSettingsResponse(
    public val domainNameLabel: String? = null,
    public val fqdn: String? = null,
    public val publicIpAllocationMethod: String? = null,
    public val resourceType: String,
    public val sku: String? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
    public val zones: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PublicIPAddressResourceSettingsResponse):
            PublicIPAddressResourceSettingsResponse = PublicIPAddressResourceSettingsResponse(
            domainNameLabel = javaType.domainNameLabel().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            publicIpAllocationMethod = javaType.publicIpAllocationMethod().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType(),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
            zones = javaType.zones().map({ args0 -> args0 }).orElse(null),
        )
    }
}
