@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Business case report details.
 * @property reportStatus Report status.
 * @property reportType Report type.
 */
public data class ReportDetailsResponse(
    public val reportStatus: String,
    public val reportType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ReportDetailsResponse):
            ReportDetailsResponse = ReportDetailsResponse(
            reportStatus = javaType.reportStatus(),
            reportType = javaType.reportType(),
        )
    }
}
