@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Class representing the details of the solution.
 * @property assessmentCount Gets or sets the count of assessments reported by the solution.
 * @property extendedDetails Gets or sets the extended details reported by the solution.
 * @property groupCount Gets or sets the count of groups reported by the solution.
 */
public data class SolutionDetailsResponse(
    public val assessmentCount: Int? = null,
    public val extendedDetails: Map<String, String>? = null,
    public val groupCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SolutionDetailsResponse):
            SolutionDetailsResponse = SolutionDetailsResponse(
            assessmentCount = javaType.assessmentCount().map({ args0 -> args0 }).orElse(null),
            extendedDetails = javaType.extendedDetails().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            groupCount = javaType.groupCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
