@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Virtualization software settings.
 * @property licenseAndSupportList Licence and support list.
 * @property numberOfPhysicalCoresPerLicense Number of physical cores per licence.
 * @property softwareAssuranceCost Software Assurance cost.
 */
public data class VirtualizationSoftwareSettingsResponse(
    public val licenseAndSupportList: List<VsphereLicenseResponse>,
    public val numberOfPhysicalCoresPerLicense: Int,
    public val softwareAssuranceCost: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VirtualizationSoftwareSettingsResponse):
            VirtualizationSoftwareSettingsResponse = VirtualizationSoftwareSettingsResponse(
            licenseAndSupportList = javaType.licenseAndSupportList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.VsphereLicenseResponse.Companion.toKotlin(args0)
                })
            }),
            numberOfPhysicalCoresPerLicense = javaType.numberOfPhysicalCoresPerLicense(),
            softwareAssuranceCost = javaType.softwareAssuranceCost(),
        )
    }
}
