@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Framework specific data for a web application.
 * @property id Gets the ID.
 * @property name Gets or sets Name of the framework.
 * @property version Gets or sets Version of the framework.
 */
public data class WebApplicationFrameworkResponse(
    public val id: String,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WebApplicationFrameworkResponse):
            WebApplicationFrameworkResponse = WebApplicationFrameworkResponse(
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
