@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin

import com.pulumi.azurenative.mixedreality.RemoteRenderingAccountArgs.builder
import com.pulumi.azurenative.mixedreality.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.mixedreality.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.mixedreality.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.mixedreality.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * RemoteRenderingAccount Response.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2021-03-01-preview.
 * ## Example Usage
 * ### Create remote rendering account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var remoteRenderingAccount = new AzureNative.MixedReality.RemoteRenderingAccount("remoteRenderingAccount", new()
 *     {
 *         AccountName = "MyAccount",
 *         Identity = new AzureNative.MixedReality.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.MixedReality.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2euap",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mixedreality/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mixedreality.NewRemoteRenderingAccount(ctx, "remoteRenderingAccount", &mixedreality.RemoteRenderingAccountArgs{
 * 			AccountName: pulumi.String("MyAccount"),
 * 			Identity: &mixedreality.IdentityArgs{
 * 				Type: mixedreality.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mixedreality.RemoteRenderingAccount;
 * import com.pulumi.azurenative.mixedreality.RemoteRenderingAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var remoteRenderingAccount = new RemoteRenderingAccount("remoteRenderingAccount", RemoteRenderingAccountArgs.builder()
 *             .accountName("MyAccount")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus2euap")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mixedreality:RemoteRenderingAccount MyAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MixedReality/remoteRenderingAccounts/{accountName}
 * ```
 * @property accountName Name of an Mixed Reality Account.
 * @property identity The identity associated with this account
 * @property kind The kind of account, if supported
 * @property location The geo-location where the resource lives
 * @property plan The plan associated with this account
 * @property resourceGroupName Name of an Azure resource group.
 * @property sku The sku associated with this account
 * @property storageAccountName The name of the storage account associated with this accountId
 * @property tags Resource tags.
 */
public data class RemoteRenderingAccountArgs(
    public val accountName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val kind: Output<SkuArgs>? = null,
    public val location: Output<String>? = null,
    public val plan: Output<IdentityArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val storageAccountName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mixedreality.RemoteRenderingAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.mixedreality.RemoteRenderingAccountArgs =
        com.pulumi.azurenative.mixedreality.RemoteRenderingAccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RemoteRenderingAccountArgs].
 */
@PulumiTagMarker
public class RemoteRenderingAccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var kind: Output<SkuArgs>? = null

    private var location: Output<String>? = null

    private var plan: Output<IdentityArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var storageAccountName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of an Mixed Reality Account.
     */
    @JvmName("tgxogbslglnctske")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The identity associated with this account
     */
    @JvmName("dqapedthlbpvqnow")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of account, if supported
     */
    @JvmName("yaorutnwdjrehudf")
    public suspend fun kind(`value`: Output<SkuArgs>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ptovyfbwaypgrugv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The plan associated with this account
     */
    @JvmName("ofenuudnysvqqopx")
    public suspend fun plan(`value`: Output<IdentityArgs>) {
        this.plan = value
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("vypwnuakyfdwuqul")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku associated with this account
     */
    @JvmName("fwfrphygpuycmpcy")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the storage account associated with this accountId
     */
    @JvmName("pkocgwvejpvttcos")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qkyynncyogvuelfb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of an Mixed Reality Account.
     */
    @JvmName("gryqqochoskkebhe")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The identity associated with this account
     */
    @JvmName("uxtespyilpypsddu")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity associated with this account
     */
    @JvmName("elqtxuxscdxvwxwu")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of account, if supported
     */
    @JvmName("sgrbweolkrtxawyj")
    public suspend fun kind(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param argument The kind of account, if supported
     */
    @JvmName("jpkncwufljckkgff")
    public suspend fun kind(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mitiwklypfbnuelr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The plan associated with this account
     */
    @JvmName("csbnbslbbwvbbevq")
    public suspend fun plan(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument The plan associated with this account
     */
    @JvmName("gnkfxsaruhskwoxv")
    public suspend fun plan(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("wkddifmaxtjrcagq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku associated with this account
     */
    @JvmName("pwbmnmcwmbistjyj")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku associated with this account
     */
    @JvmName("acfwoxdrajkuqpyk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The name of the storage account associated with this accountId
     */
    @JvmName("smaowtnmjrexqivu")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tkeesljaagdgentu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mediqypuavmhospp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RemoteRenderingAccountArgs = RemoteRenderingAccountArgs(
        accountName = accountName,
        identity = identity,
        kind = kind,
        location = location,
        plan = plan,
        resourceGroupName = resourceGroupName,
        sku = sku,
        storageAccountName = storageAccountName,
        tags = tags,
    )
}
