@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin.inputs

import com.pulumi.azurenative.mixedreality.inputs.ObjectAnchorsAccountIdentityArgs.builder
import com.pulumi.azurenative.mixedreality.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The identity type.
 */
public data class ObjectAnchorsAccountIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mixedreality.inputs.ObjectAnchorsAccountIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.mixedreality.inputs.ObjectAnchorsAccountIdentityArgs =
        com.pulumi.azurenative.mixedreality.inputs.ObjectAnchorsAccountIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ObjectAnchorsAccountIdentityArgs].
 */
@PulumiTagMarker
public class ObjectAnchorsAccountIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("ylsdcibiuleqmvkf")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("xtuhniycbixdyhcv")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ObjectAnchorsAccountIdentityArgs = ObjectAnchorsAccountIdentityArgs(
        type = type,
    )
}
