@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.NaptConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.NaptConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Attached data network resource. Must be created in the same location as its parent packet core data plane.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create attached data network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachedDataNetwork = new AzureNative.MobileNetwork.AttachedDataNetwork("attachedDataNetwork", new()
 *     {
 *         AttachedDataNetworkName = "TestAttachedDataNetwork",
 *         DnsAddresses = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         Location = "eastus",
 *         NaptConfiguration = new AzureNative.MobileNetwork.Inputs.NaptConfigurationArgs
 *         {
 *             Enabled = "Enabled",
 *             PinholeLimits = 65536,
 *             PinholeTimeouts = new AzureNative.MobileNetwork.Inputs.PinholeTimeoutsArgs
 *             {
 *                 Icmp = 30,
 *                 Tcp = 180,
 *                 Udp = 30,
 *             },
 *             PortRange = new AzureNative.MobileNetwork.Inputs.PortRangeArgs
 *             {
 *                 MaxPort = 49999,
 *                 MinPort = 1024,
 *             },
 *             PortReuseHoldTime = new AzureNative.MobileNetwork.Inputs.PortReuseHoldTimesArgs
 *             {
 *                 Tcp = 120,
 *                 Udp = 60,
 *             },
 *         },
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         PacketCoreDataPlaneName = "TestPacketCoreDP",
 *         ResourceGroupName = "rg1",
 *         UserEquipmentAddressPoolPrefix = new[]
 *         {
 *             "2.2.0.0/16",
 *         },
 *         UserEquipmentStaticAddressPoolPrefix = new[]
 *         {
 *             "2.4.0.0/16",
 *         },
 *         UserPlaneDataInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N6",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewAttachedDataNetwork(ctx, "attachedDataNetwork", &mobilenetwork.AttachedDataNetworkArgs{
 * 			AttachedDataNetworkName: pulumi.String("TestAttachedDataNetwork"),
 * 			DnsAddresses: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NaptConfiguration: mobilenetwork.NaptConfigurationResponse{
 * 				Enabled:       pulumi.String("Enabled"),
 * 				PinholeLimits: pulumi.Int(65536),
 * 				PinholeTimeouts: &mobilenetwork.PinholeTimeoutsArgs{
 * 					Icmp: pulumi.Int(30),
 * 					Tcp:  pulumi.Int(180),
 * 					Udp:  pulumi.Int(30),
 * 				},
 * 				PortRange: &mobilenetwork.PortRangeArgs{
 * 					MaxPort: pulumi.Int(49999),
 * 					MinPort: pulumi.Int(1024),
 * 				},
 * 				PortReuseHoldTime: &mobilenetwork.PortReuseHoldTimesArgs{
 * 					Tcp: pulumi.Int(120),
 * 					Udp: pulumi.Int(60),
 * 				},
 * 			},
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			PacketCoreDataPlaneName:    pulumi.String("TestPacketCoreDP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			UserEquipmentAddressPoolPrefix: pulumi.StringArray{
 * 				pulumi.String("2.2.0.0/16"),
 * 			},
 * 			UserEquipmentStaticAddressPoolPrefix: pulumi.StringArray{
 * 				pulumi.String("2.4.0.0/16"),
 * 			},
 * 			UserPlaneDataInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N6"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork;
 * import com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachedDataNetwork = new AttachedDataNetwork("attachedDataNetwork", AttachedDataNetworkArgs.builder()
 *             .attachedDataNetworkName("TestAttachedDataNetwork")
 *             .dnsAddresses("1.1.1.1")
 *             .location("eastus")
 *             .naptConfiguration(Map.ofEntries(
 *                 Map.entry("enabled", "Enabled"),
 *                 Map.entry("pinholeLimits", 65536),
 *                 Map.entry("pinholeTimeouts", Map.ofEntries(
 *                     Map.entry("icmp", 30),
 *                     Map.entry("tcp", 180),
 *                     Map.entry("udp", 30)
 *                 )),
 *                 Map.entry("portRange", Map.ofEntries(
 *                     Map.entry("maxPort", 49999),
 *                     Map.entry("minPort", 1024)
 *                 )),
 *                 Map.entry("portReuseHoldTime", Map.ofEntries(
 *                     Map.entry("tcp", 120),
 *                     Map.entry("udp", 60)
 *                 ))
 *             ))
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .packetCoreDataPlaneName("TestPacketCoreDP")
 *             .resourceGroupName("rg1")
 *             .userEquipmentAddressPoolPrefix("2.2.0.0/16")
 *             .userEquipmentStaticAddressPoolPrefix("2.4.0.0/16")
 *             .userPlaneDataInterface(Map.of("name", "N6"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:AttachedDataNetwork TestAttachedDataNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCoreDataPlanes/{packetCoreDataPlaneName}/attachedDataNetworks/{attachedDataNetworkName}
 * ```
 * @property attachedDataNetworkName The name of the attached data network.
 * @property dnsAddresses The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
 * @property location The geo-location where the resource lives
 * @property naptConfiguration The network address and port translation (NAPT) configuration.
 * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property packetCoreDataPlaneName The name of the packet core data plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property userEquipmentAddressPoolPrefix The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
 * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
 *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
 * @property userEquipmentStaticAddressPoolPrefix The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
 * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
 * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
 * @property userPlaneDataInterface The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
 */
public data class AttachedDataNetworkArgs(
    public val attachedDataNetworkName: Output<String>? = null,
    public val dnsAddresses: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val naptConfiguration: Output<NaptConfigurationArgs>? = null,
    public val packetCoreControlPlaneName: Output<String>? = null,
    public val packetCoreDataPlaneName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userEquipmentAddressPoolPrefix: Output<List<String>>? = null,
    public val userEquipmentStaticAddressPoolPrefix: Output<List<String>>? = null,
    public val userPlaneDataInterface: Output<InterfacePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs =
        com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs.builder()
            .attachedDataNetworkName(attachedDataNetworkName?.applyValue({ args0 -> args0 }))
            .dnsAddresses(dnsAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .naptConfiguration(naptConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName?.applyValue({ args0 -> args0 }))
            .packetCoreDataPlaneName(packetCoreDataPlaneName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userEquipmentAddressPoolPrefix(
                userEquipmentAddressPoolPrefix?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .userEquipmentStaticAddressPoolPrefix(
                userEquipmentStaticAddressPoolPrefix?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .userPlaneDataInterface(
                userPlaneDataInterface?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AttachedDataNetworkArgs].
 */
@PulumiTagMarker
public class AttachedDataNetworkArgsBuilder internal constructor() {
    private var attachedDataNetworkName: Output<String>? = null

    private var dnsAddresses: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var naptConfiguration: Output<NaptConfigurationArgs>? = null

    private var packetCoreControlPlaneName: Output<String>? = null

    private var packetCoreDataPlaneName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userEquipmentAddressPoolPrefix: Output<List<String>>? = null

    private var userEquipmentStaticAddressPoolPrefix: Output<List<String>>? = null

    private var userPlaneDataInterface: Output<InterfacePropertiesArgs>? = null

    /**
     * @param value The name of the attached data network.
     */
    @JvmName("cckhveceyeodvmvk")
    public suspend fun attachedDataNetworkName(`value`: Output<String>) {
        this.attachedDataNetworkName = value
    }

    /**
     * @param value The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
     */
    @JvmName("xgewttubrcjtppgw")
    public suspend fun dnsAddresses(`value`: Output<List<String>>) {
        this.dnsAddresses = value
    }

    @JvmName("vbojfhbrxoyfeldm")
    public suspend fun dnsAddresses(vararg values: Output<String>) {
        this.dnsAddresses = Output.all(values.asList())
    }

    /**
     * @param values The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
     */
    @JvmName("bnxnxsuaajsfhbei")
    public suspend fun dnsAddresses(values: List<Output<String>>) {
        this.dnsAddresses = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ivlfwwnljfmushlb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network address and port translation (NAPT) configuration.
     * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
     */
    @JvmName("qgrjvgdpxshdugfk")
    public suspend fun naptConfiguration(`value`: Output<NaptConfigurationArgs>) {
        this.naptConfiguration = value
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("hctvfrocskcyoygn")
    public suspend fun packetCoreControlPlaneName(`value`: Output<String>) {
        this.packetCoreControlPlaneName = value
    }

    /**
     * @param value The name of the packet core data plane.
     */
    @JvmName("uxxumxkayaaochoa")
    public suspend fun packetCoreDataPlaneName(`value`: Output<String>) {
        this.packetCoreDataPlaneName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mwkacrbyssvpswue")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jmjvffmlcrxrngja")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
     *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
     */
    @JvmName("vrloaxlcmmnoxbie")
    public suspend fun userEquipmentAddressPoolPrefix(`value`: Output<List<String>>) {
        this.userEquipmentAddressPoolPrefix = value
    }

    @JvmName("rbderoytbrgwqenh")
    public suspend fun userEquipmentAddressPoolPrefix(vararg values: Output<String>) {
        this.userEquipmentAddressPoolPrefix = Output.all(values.asList())
    }

    /**
     * @param values The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
     *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
     */
    @JvmName("phlhqhlqabyrmpuu")
    public suspend fun userEquipmentAddressPoolPrefix(values: List<Output<String>>) {
        this.userEquipmentAddressPoolPrefix = Output.all(values)
    }

    /**
     * @param value The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
     * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
     */
    @JvmName("huxngnrnrftobgdf")
    public suspend fun userEquipmentStaticAddressPoolPrefix(`value`: Output<List<String>>) {
        this.userEquipmentStaticAddressPoolPrefix = value
    }

    @JvmName("vxbnkhrvfayadnlt")
    public suspend fun userEquipmentStaticAddressPoolPrefix(vararg values: Output<String>) {
        this.userEquipmentStaticAddressPoolPrefix = Output.all(values.asList())
    }

    /**
     * @param values The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
     * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
     */
    @JvmName("fdcggjcbhlcgauhp")
    public suspend fun userEquipmentStaticAddressPoolPrefix(values: List<Output<String>>) {
        this.userEquipmentStaticAddressPoolPrefix = Output.all(values)
    }

    /**
     * @param value The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    @JvmName("cefbxynmauttvmip")
    public suspend fun userPlaneDataInterface(`value`: Output<InterfacePropertiesArgs>) {
        this.userPlaneDataInterface = value
    }

    /**
     * @param value The name of the attached data network.
     */
    @JvmName("qbwlhgeygaklqscn")
    public suspend fun attachedDataNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedDataNetworkName = mapped
    }

    /**
     * @param value The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
     */
    @JvmName("dsnhjqxnnwqvatje")
    public suspend fun dnsAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param values The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
     */
    @JvmName("gyogknytpvtubkfc")
    public suspend fun dnsAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ejmcneukvskkrrwd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network address and port translation (NAPT) configuration.
     * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
     */
    @JvmName("ynbjfogxnbcimtlp")
    public suspend fun naptConfiguration(`value`: NaptConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.naptConfiguration = mapped
    }

    /**
     * @param argument The network address and port translation (NAPT) configuration.
     * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
     */
    @JvmName("nbkypwyocntcaian")
    public suspend fun naptConfiguration(argument: suspend NaptConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NaptConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.naptConfiguration = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("qknvayrjuqptcajj")
    public suspend fun packetCoreControlPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the packet core data plane.
     */
    @JvmName("ipinvwfyffamhyud")
    public suspend fun packetCoreDataPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreDataPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fwuuqlouamkvggax")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nocemrrwxwqsefib")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kminarkbcxiajysm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
     *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
     */
    @JvmName("lokglnuefsbxmmnj")
    public suspend fun userEquipmentAddressPoolPrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEquipmentAddressPoolPrefix = mapped
    }

    /**
     * @param values The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
     *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
     */
    @JvmName("kenqgkjjlxwsftrs")
    public suspend fun userEquipmentAddressPoolPrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userEquipmentAddressPoolPrefix = mapped
    }

    /**
     * @param value The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
     * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
     */
    @JvmName("ajnxvdfhgfckvoeb")
    public suspend fun userEquipmentStaticAddressPoolPrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEquipmentStaticAddressPoolPrefix = mapped
    }

    /**
     * @param values The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
     * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
     */
    @JvmName("wvdmbkrsiqvqkpyg")
    public suspend fun userEquipmentStaticAddressPoolPrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userEquipmentStaticAddressPoolPrefix = mapped
    }

    /**
     * @param value The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    @JvmName("kodcjgsxiywegdpd")
    public suspend fun userPlaneDataInterface(`value`: InterfacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPlaneDataInterface = mapped
    }

    /**
     * @param argument The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    @JvmName("crplplhelqqmhnkc")
    public suspend
    fun userPlaneDataInterface(argument: suspend InterfacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = InterfacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userPlaneDataInterface = mapped
    }

    internal fun build(): AttachedDataNetworkArgs = AttachedDataNetworkArgs(
        attachedDataNetworkName = attachedDataNetworkName,
        dnsAddresses = dnsAddresses,
        location = location,
        naptConfiguration = naptConfiguration,
        packetCoreControlPlaneName = packetCoreControlPlaneName,
        packetCoreDataPlaneName = packetCoreDataPlaneName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userEquipmentAddressPoolPrefix = userEquipmentAddressPoolPrefix,
        userEquipmentStaticAddressPoolPrefix = userEquipmentStaticAddressPoolPrefix,
        userPlaneDataInterface = userPlaneDataInterface,
    )
}
