@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DiagnosticsPackage].
 */
@PulumiTagMarker
public class DiagnosticsPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiagnosticsPackageArgs = DiagnosticsPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiagnosticsPackageArgsBuilder.() -> Unit) {
        val builder = DiagnosticsPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiagnosticsPackage {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DiagnosticsPackage(builtJavaResource)
    }
}

/**
 * Diagnostics package resource.
 * Azure REST API version: 2023-06-01.
 * Other available API versions: 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create diagnostics package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticsPackage = new AzureNative.MobileNetwork.DiagnosticsPackage("diagnosticsPackage", new()
 *     {
 *         DiagnosticsPackageName = "dp1",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewDiagnosticsPackage(ctx, "diagnosticsPackage", &mobilenetwork.DiagnosticsPackageArgs{
 * 			DiagnosticsPackageName:     pulumi.String("dp1"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage;
 * import com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticsPackage = new DiagnosticsPackage("diagnosticsPackage", DiagnosticsPackageArgs.builder()
 *             .diagnosticsPackageName("dp1")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:DiagnosticsPackage dp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}
 * ```
 */
public class DiagnosticsPackage internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage,
) : KotlinCustomResource(javaResource, DiagnosticsPackageMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the diagnostics package resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reason for the current state of the diagnostics package collection.
     */
    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })

    /**
     * The status of the diagnostics package collection.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiagnosticsPackageMapper : ResourceMapper<DiagnosticsPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage::class == javaResource::class

    override fun map(javaResource: Resource): DiagnosticsPackage = DiagnosticsPackage(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage,
    )
}

/**
 * @see [DiagnosticsPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiagnosticsPackage].
 */
public suspend fun diagnosticsPackage(
    name: String,
    block: suspend DiagnosticsPackageResourceBuilder.() -> Unit,
): DiagnosticsPackage {
    val builder = DiagnosticsPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiagnosticsPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diagnosticsPackage(name: String): DiagnosticsPackage {
    val builder = DiagnosticsPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
