@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PacketCapture].
 */
@PulumiTagMarker
public class PacketCaptureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PacketCaptureArgs = PacketCaptureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PacketCaptureArgsBuilder.() -> Unit) {
        val builder = PacketCaptureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PacketCapture {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.PacketCapture(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PacketCapture(builtJavaResource)
    }
}

/**
 * Packet capture session resource.
 * Azure REST API version: 2023-06-01.
 * Other available API versions: 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create packet capture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCapture = new AzureNative.MobileNetwork.PacketCapture("packetCapture", new()
 *     {
 *         BytesToCapturePerPacket = 10000,
 *         NetworkInterfaces = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN",
 *         },
 *         PacketCaptureName = "pc1",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         ResourceGroupName = "rg1",
 *         TimeLimitInSeconds = 100,
 *         TotalBytesPerSession = 100000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCapture(ctx, "packetCapture", &mobilenetwork.PacketCaptureArgs{
 * 			BytesToCapturePerPacket: pulumi.Float64(10000),
 * 			NetworkInterfaces: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN"),
 * 			},
 * 			PacketCaptureName:          pulumi.String("pc1"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			TimeLimitInSeconds:         pulumi.Int(100),
 * 			TotalBytesPerSession:       pulumi.Float64(100000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCapture;
 * import com.pulumi.azurenative.mobilenetwork.PacketCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCapture = new PacketCapture("packetCapture", PacketCaptureArgs.builder()
 *             .bytesToCapturePerPacket(10000)
 *             .networkInterfaces(
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestADN")
 *             .packetCaptureName("pc1")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .resourceGroupName("rg1")
 *             .timeLimitInSeconds(100)
 *             .totalBytesPerSession(100000)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCapture pc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCaptures/{packetCaptureName}
 * ```
 */
public class PacketCapture internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.PacketCapture,
) : KotlinCustomResource(javaResource, PacketCaptureMapper) {
    /**
     * Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
     */
    public val bytesToCapturePerPacket: Output<Double>?
        get() = javaResource.bytesToCapturePerPacket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start time of the packet capture session.
     */
    public val captureStartTime: Output<String>
        get() = javaResource.captureStartTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of network interfaces to capture on.
     */
    public val networkInterfaces: Output<List<String>>?
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The provisioning state of the packet capture session resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reason the current packet capture session state.
     */
    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })

    /**
     * The status of the packet capture session.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Maximum duration of the capture session in seconds.
     */
    public val timeLimitInSeconds: Output<Int>?
        get() = javaResource.timeLimitInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum size of the capture output.
     */
    public val totalBytesPerSession: Output<Double>?
        get() = javaResource.totalBytesPerSession().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PacketCaptureMapper : ResourceMapper<PacketCapture> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.PacketCapture::class == javaResource::class

    override fun map(javaResource: Resource): PacketCapture = PacketCapture(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.PacketCapture,
    )
}

/**
 * @see [PacketCapture].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PacketCapture].
 */
public suspend fun packetCapture(
    name: String,
    block: suspend PacketCaptureResourceBuilder.() -> Unit,
): PacketCapture {
    val builder = PacketCaptureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PacketCapture].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packetCapture(name: String): PacketCapture {
    val builder = PacketCaptureResourceBuilder()
    builder.name(name)
    return builder.build()
}
