@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PccRuleConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.QosPolicyResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PccRuleConfigurationResponse.Companion.toKotlin as pccRuleConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.QosPolicyResponse.Companion.toKotlin as qosPolicyResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.mobilenetwork.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Service resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.MobileNetwork.Service("service", new()
 *     {
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         PccRules = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.PccRuleConfigurationArgs
 *             {
 *                 RuleName = "default-rule",
 *                 RulePrecedence = 255,
 *                 RuleQosPolicy = new AzureNative.MobileNetwork.Inputs.PccRuleQosPolicyArgs
 *                 {
 *                     AllocationAndRetentionPriorityLevel = 9,
 *                     FiveQi = 9,
 *                     MaximumBitRate = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *                     {
 *                         Downlink = "1 Gbps",
 *                         Uplink = "500 Mbps",
 *                     },
 *                     PreemptionCapability = "NotPreempt",
 *                     PreemptionVulnerability = "Preemptable",
 *                 },
 *                 ServiceDataFlowTemplates = new[]
 *                 {
 *                     new AzureNative.MobileNetwork.Inputs.ServiceDataFlowTemplateArgs
 *                     {
 *                         Direction = "Uplink",
 *                         Ports = new() { },
 *                         Protocol = new[]
 *                         {
 *                             "ip",
 *                         },
 *                         RemoteIpList = new[]
 *                         {
 *                             "10.3.4.0/24",
 *                         },
 *                         TemplateName = "IP-to-server",
 *                     },
 *                 },
 *                 TrafficControl = "Enabled",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "TestService",
 *         ServicePrecedence = 255,
 *         ServiceQosPolicy = new AzureNative.MobileNetwork.Inputs.QosPolicyArgs
 *         {
 *             AllocationAndRetentionPriorityLevel = 9,
 *             FiveQi = 9,
 *             MaximumBitRate = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *             {
 *                 Downlink = "1 Gbps",
 *                 Uplink = "500 Mbps",
 *             },
 *             PreemptionCapability = "NotPreempt",
 *             PreemptionVulnerability = "Preemptable",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewService(ctx, "service", &mobilenetwork.ServiceArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			PccRules: []mobilenetwork.PccRuleConfigurationArgs{
 * 				{
 * 					RuleName:       pulumi.String("default-rule"),
 * 					RulePrecedence: pulumi.Int(255),
 * 					RuleQosPolicy: {
 * 						AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 						FiveQi:                              pulumi.Int(9),
 * 						MaximumBitRate: {
 * 							Downlink: pulumi.String("1 Gbps"),
 * 							Uplink:   pulumi.String("500 Mbps"),
 * 						},
 * 						PreemptionCapability:    pulumi.String("NotPreempt"),
 * 						PreemptionVulnerability: pulumi.String("Preemptable"),
 * 					},
 * 					ServiceDataFlowTemplates: mobilenetwork.ServiceDataFlowTemplateArray{
 * 						{
 * 							Direction: pulumi.String("Uplink"),
 * 							Ports:     pulumi.StringArray{},
 * 							Protocol: pulumi.StringArray{
 * 								pulumi.String("ip"),
 * 							},
 * 							RemoteIpList: pulumi.StringArray{
 * 								pulumi.String("10.3.4.0/24"),
 * 							},
 * 							TemplateName: pulumi.String("IP-to-server"),
 * 						},
 * 					},
 * 					TrafficControl: pulumi.String("Enabled"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("TestService"),
 * 			ServicePrecedence: pulumi.Int(255),
 * 			ServiceQosPolicy: mobilenetwork.QosPolicyResponse{
 * 				AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 				FiveQi:                              pulumi.Int(9),
 * 				MaximumBitRate: &mobilenetwork.AmbrArgs{
 * 					Downlink: pulumi.String("1 Gbps"),
 * 					Uplink:   pulumi.String("500 Mbps"),
 * 				},
 * 				PreemptionCapability:    pulumi.String("NotPreempt"),
 * 				PreemptionVulnerability: pulumi.String("Preemptable"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Service;
 * import com.pulumi.azurenative.mobilenetwork.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .pccRules(Map.ofEntries(
 *                 Map.entry("ruleName", "default-rule"),
 *                 Map.entry("rulePrecedence", 255),
 *                 Map.entry("ruleQosPolicy", Map.ofEntries(
 *                     Map.entry("allocationAndRetentionPriorityLevel", 9),
 *                     Map.entry("fiveQi", 9),
 *                     Map.entry("maximumBitRate", Map.ofEntries(
 *                         Map.entry("downlink", "1 Gbps"),
 *                         Map.entry("uplink", "500 Mbps")
 *                     )),
 *                     Map.entry("preemptionCapability", "NotPreempt"),
 *                     Map.entry("preemptionVulnerability", "Preemptable")
 *                 )),
 *                 Map.entry("serviceDataFlowTemplates", Map.ofEntries(
 *                     Map.entry("direction", "Uplink"),
 *                     Map.entry("ports", ),
 *                     Map.entry("protocol", "ip"),
 *                     Map.entry("remoteIpList", "10.3.4.0/24"),
 *                     Map.entry("templateName", "IP-to-server")
 *                 )),
 *                 Map.entry("trafficControl", "Enabled")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("TestService")
 *             .servicePrecedence(255)
 *             .serviceQosPolicy(Map.ofEntries(
 *                 Map.entry("allocationAndRetentionPriorityLevel", 9),
 *                 Map.entry("fiveQi", 9),
 *                 Map.entry("maximumBitRate", Map.ofEntries(
 *                     Map.entry("downlink", "1 Gbps"),
 *                     Map.entry("uplink", "500 Mbps")
 *                 )),
 *                 Map.entry("preemptionCapability", "NotPreempt"),
 *                 Map.entry("preemptionVulnerability", "Preemptable")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Service testPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/services/{serviceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of data flow policy rules that make up this service.
     */
    public val pccRules: Output<List<PccRuleConfigurationResponse>>
        get() = javaResource.pccRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pccRuleConfigurationResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state of the service resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A precedence value that is used to decide between services when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all services configured in the mobile network.
     */
    public val servicePrecedence: Output<Int>
        get() = javaResource.servicePrecedence().applyValue({ args0 -> args0 })

    /**
     * The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If this field is null then the UE's SIM policy will define the QoS settings.
     */
    public val serviceQosPolicy: Output<QosPolicyResponse>?
        get() = javaResource.serviceQosPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> qosPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
