@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.ServiceArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PccRuleConfigurationArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PccRuleConfigurationArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.QosPolicyArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.QosPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Service resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.MobileNetwork.Service("service", new()
 *     {
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         PccRules = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.PccRuleConfigurationArgs
 *             {
 *                 RuleName = "default-rule",
 *                 RulePrecedence = 255,
 *                 RuleQosPolicy = new AzureNative.MobileNetwork.Inputs.PccRuleQosPolicyArgs
 *                 {
 *                     AllocationAndRetentionPriorityLevel = 9,
 *                     FiveQi = 9,
 *                     MaximumBitRate = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *                     {
 *                         Downlink = "1 Gbps",
 *                         Uplink = "500 Mbps",
 *                     },
 *                     PreemptionCapability = "NotPreempt",
 *                     PreemptionVulnerability = "Preemptable",
 *                 },
 *                 ServiceDataFlowTemplates = new[]
 *                 {
 *                     new AzureNative.MobileNetwork.Inputs.ServiceDataFlowTemplateArgs
 *                     {
 *                         Direction = "Uplink",
 *                         Ports = new() { },
 *                         Protocol = new[]
 *                         {
 *                             "ip",
 *                         },
 *                         RemoteIpList = new[]
 *                         {
 *                             "10.3.4.0/24",
 *                         },
 *                         TemplateName = "IP-to-server",
 *                     },
 *                 },
 *                 TrafficControl = "Enabled",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "TestService",
 *         ServicePrecedence = 255,
 *         ServiceQosPolicy = new AzureNative.MobileNetwork.Inputs.QosPolicyArgs
 *         {
 *             AllocationAndRetentionPriorityLevel = 9,
 *             FiveQi = 9,
 *             MaximumBitRate = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *             {
 *                 Downlink = "1 Gbps",
 *                 Uplink = "500 Mbps",
 *             },
 *             PreemptionCapability = "NotPreempt",
 *             PreemptionVulnerability = "Preemptable",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewService(ctx, "service", &mobilenetwork.ServiceArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			PccRules: []mobilenetwork.PccRuleConfigurationArgs{
 * 				{
 * 					RuleName:       pulumi.String("default-rule"),
 * 					RulePrecedence: pulumi.Int(255),
 * 					RuleQosPolicy: {
 * 						AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 						FiveQi:                              pulumi.Int(9),
 * 						MaximumBitRate: {
 * 							Downlink: pulumi.String("1 Gbps"),
 * 							Uplink:   pulumi.String("500 Mbps"),
 * 						},
 * 						PreemptionCapability:    pulumi.String("NotPreempt"),
 * 						PreemptionVulnerability: pulumi.String("Preemptable"),
 * 					},
 * 					ServiceDataFlowTemplates: mobilenetwork.ServiceDataFlowTemplateArray{
 * 						{
 * 							Direction: pulumi.String("Uplink"),
 * 							Ports:     pulumi.StringArray{},
 * 							Protocol: pulumi.StringArray{
 * 								pulumi.String("ip"),
 * 							},
 * 							RemoteIpList: pulumi.StringArray{
 * 								pulumi.String("10.3.4.0/24"),
 * 							},
 * 							TemplateName: pulumi.String("IP-to-server"),
 * 						},
 * 					},
 * 					TrafficControl: pulumi.String("Enabled"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("TestService"),
 * 			ServicePrecedence: pulumi.Int(255),
 * 			ServiceQosPolicy: mobilenetwork.QosPolicyResponse{
 * 				AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 				FiveQi:                              pulumi.Int(9),
 * 				MaximumBitRate: &mobilenetwork.AmbrArgs{
 * 					Downlink: pulumi.String("1 Gbps"),
 * 					Uplink:   pulumi.String("500 Mbps"),
 * 				},
 * 				PreemptionCapability:    pulumi.String("NotPreempt"),
 * 				PreemptionVulnerability: pulumi.String("Preemptable"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Service;
 * import com.pulumi.azurenative.mobilenetwork.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .pccRules(Map.ofEntries(
 *                 Map.entry("ruleName", "default-rule"),
 *                 Map.entry("rulePrecedence", 255),
 *                 Map.entry("ruleQosPolicy", Map.ofEntries(
 *                     Map.entry("allocationAndRetentionPriorityLevel", 9),
 *                     Map.entry("fiveQi", 9),
 *                     Map.entry("maximumBitRate", Map.ofEntries(
 *                         Map.entry("downlink", "1 Gbps"),
 *                         Map.entry("uplink", "500 Mbps")
 *                     )),
 *                     Map.entry("preemptionCapability", "NotPreempt"),
 *                     Map.entry("preemptionVulnerability", "Preemptable")
 *                 )),
 *                 Map.entry("serviceDataFlowTemplates", Map.ofEntries(
 *                     Map.entry("direction", "Uplink"),
 *                     Map.entry("ports", ),
 *                     Map.entry("protocol", "ip"),
 *                     Map.entry("remoteIpList", "10.3.4.0/24"),
 *                     Map.entry("templateName", "IP-to-server")
 *                 )),
 *                 Map.entry("trafficControl", "Enabled")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("TestService")
 *             .servicePrecedence(255)
 *             .serviceQosPolicy(Map.ofEntries(
 *                 Map.entry("allocationAndRetentionPriorityLevel", 9),
 *                 Map.entry("fiveQi", 9),
 *                 Map.entry("maximumBitRate", Map.ofEntries(
 *                     Map.entry("downlink", "1 Gbps"),
 *                     Map.entry("uplink", "500 Mbps")
 *                 )),
 *                 Map.entry("preemptionCapability", "NotPreempt"),
 *                 Map.entry("preemptionVulnerability", "Preemptable")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Service testPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/services/{serviceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property pccRules The set of data flow policy rules that make up this service.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the service. You must not use any of the following reserved strings - `default`, `requested` or `service`
 * @property servicePrecedence A precedence value that is used to decide between services when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all services configured in the mobile network.
 * @property serviceQosPolicy The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If this field is null then the UE's SIM policy will define the QoS settings.
 * @property tags Resource tags.
 */
public data class ServiceArgs(
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val pccRules: Output<List<PccRuleConfigurationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val servicePrecedence: Output<Int>? = null,
    public val serviceQosPolicy: Output<QosPolicyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.ServiceArgs =
        com.pulumi.azurenative.mobilenetwork.ServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .pccRules(
                pccRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .servicePrecedence(servicePrecedence?.applyValue({ args0 -> args0 }))
            .serviceQosPolicy(serviceQosPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var pccRules: Output<List<PccRuleConfigurationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var servicePrecedence: Output<Int>? = null

    private var serviceQosPolicy: Output<QosPolicyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fbtetxegmyiyeafw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("paolcneajlheqhny")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value The set of data flow policy rules that make up this service.
     */
    @JvmName("mtcvsmoipogkvciy")
    public suspend fun pccRules(`value`: Output<List<PccRuleConfigurationArgs>>) {
        this.pccRules = value
    }

    @JvmName("qrakkqcwrmbsniky")
    public suspend fun pccRules(vararg values: Output<PccRuleConfigurationArgs>) {
        this.pccRules = Output.all(values.asList())
    }

    /**
     * @param values The set of data flow policy rules that make up this service.
     */
    @JvmName("wnqjdrvnuawwqksj")
    public suspend fun pccRules(values: List<Output<PccRuleConfigurationArgs>>) {
        this.pccRules = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ijyvcuoykakumodx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service. You must not use any of the following reserved strings - `default`, `requested` or `service`
     */
    @JvmName("nihlfwiwvplxmvtv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value A precedence value that is used to decide between services when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all services configured in the mobile network.
     */
    @JvmName("sqyecjfdbwnafevr")
    public suspend fun servicePrecedence(`value`: Output<Int>) {
        this.servicePrecedence = value
    }

    /**
     * @param value The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If this field is null then the UE's SIM policy will define the QoS settings.
     */
    @JvmName("oaecjvwpfdtuqgae")
    public suspend fun serviceQosPolicy(`value`: Output<QosPolicyArgs>) {
        this.serviceQosPolicy = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bqtmrdspcynkesrj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qyfxxlgyktdbgxhi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("ffayjqfkkijuqtgw")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The set of data flow policy rules that make up this service.
     */
    @JvmName("kkvsneywgaunvxih")
    public suspend fun pccRules(`value`: List<PccRuleConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pccRules = mapped
    }

    /**
     * @param argument The set of data flow policy rules that make up this service.
     */
    @JvmName("xijsnelokkrefbqx")
    public suspend fun pccRules(argument: List<suspend PccRuleConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PccRuleConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pccRules = mapped
    }

    /**
     * @param argument The set of data flow policy rules that make up this service.
     */
    @JvmName("gewplbsgmgqcvhrh")
    public suspend fun pccRules(vararg argument: suspend PccRuleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PccRuleConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pccRules = mapped
    }

    /**
     * @param argument The set of data flow policy rules that make up this service.
     */
    @JvmName("uwvomkaulybrbrlw")
    public suspend fun pccRules(argument: suspend PccRuleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PccRuleConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pccRules = mapped
    }

    /**
     * @param values The set of data flow policy rules that make up this service.
     */
    @JvmName("cxyqqefdlncfprut")
    public suspend fun pccRules(vararg values: PccRuleConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pccRules = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dxaxqnpggjsvjsrq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service. You must not use any of the following reserved strings - `default`, `requested` or `service`
     */
    @JvmName("ysolelpphfqqpsku")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value A precedence value that is used to decide between services when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all services configured in the mobile network.
     */
    @JvmName("vgjfhervsofgxbfr")
    public suspend fun servicePrecedence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrecedence = mapped
    }

    /**
     * @param value The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If this field is null then the UE's SIM policy will define the QoS settings.
     */
    @JvmName("qecbeuhslwulngnk")
    public suspend fun serviceQosPolicy(`value`: QosPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceQosPolicy = mapped
    }

    /**
     * @param argument The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If this field is null then the UE's SIM policy will define the QoS settings.
     */
    @JvmName("oirohrajppospffa")
    public suspend fun serviceQosPolicy(argument: suspend QosPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = QosPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceQosPolicy = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nhrmtoqgtsqgqxoj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dwqrkpubdywgdnln")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        location = location,
        mobileNetworkName = mobileNetworkName,
        pccRules = pccRules,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        servicePrecedence = servicePrecedence,
        serviceQosPolicy = serviceQosPolicy,
        tags = tags,
    )
}
