@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.SimGroupArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.KeyVaultKeyArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.KeyVaultKeyArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.MobileNetworkResourceIdArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.MobileNetworkResourceIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SIM group resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:SimGroup testSimGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/simGroups/{simGroupName}
 * ```
 * @property encryptionKey A key to encrypt the SIM data that belongs to this SIM group.
 * @property identity The identity used to retrieve the encryption key from Azure key vault.
 * @property location The geo-location where the resource lives
 * @property mobileNetwork Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property simGroupName The name of the SIM Group.
 * @property tags Resource tags.
 */
public data class SimGroupArgs(
    public val encryptionKey: Output<KeyVaultKeyArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val mobileNetwork: Output<MobileNetworkResourceIdArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val simGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.SimGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.SimGroupArgs =
        com.pulumi.azurenative.mobilenetwork.SimGroupArgs.builder()
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetwork(mobileNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .simGroupName(simGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SimGroupArgs].
 */
@PulumiTagMarker
public class SimGroupArgsBuilder internal constructor() {
    private var encryptionKey: Output<KeyVaultKeyArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var mobileNetwork: Output<MobileNetworkResourceIdArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var simGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A key to encrypt the SIM data that belongs to this SIM group.
     */
    @JvmName("urdtcknnrtlehubg")
    public suspend fun encryptionKey(`value`: Output<KeyVaultKeyArgs>) {
        this.encryptionKey = value
    }

    /**
     * @param value The identity used to retrieve the encryption key from Azure key vault.
     */
    @JvmName("hopjifctshtnvgti")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fvxhgjudnqeanggs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
     */
    @JvmName("okussqiowlcudgxv")
    public suspend fun mobileNetwork(`value`: Output<MobileNetworkResourceIdArgs>) {
        this.mobileNetwork = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("alqhrpchmodatrty")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("ofpjgmguucieyasm")
    public suspend fun simGroupName(`value`: Output<String>) {
        this.simGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eupcendbfhryiuwn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A key to encrypt the SIM data that belongs to this SIM group.
     */
    @JvmName("ypltwknfxnfsjeue")
    public suspend fun encryptionKey(`value`: KeyVaultKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param argument A key to encrypt the SIM data that belongs to this SIM group.
     */
    @JvmName("xfweostikbmxluwb")
    public suspend fun encryptionKey(argument: suspend KeyVaultKeyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionKey = mapped
    }

    /**
     * @param value The identity used to retrieve the encryption key from Azure key vault.
     */
    @JvmName("igtocgmghvcfwekx")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity used to retrieve the encryption key from Azure key vault.
     */
    @JvmName("pgrepxtthqdbqdhl")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("weqmwjnewyrxkuxv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
     */
    @JvmName("whgeuyocptwbwtje")
    public suspend fun mobileNetwork(`value`: MobileNetworkResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetwork = mapped
    }

    /**
     * @param argument Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
     */
    @JvmName("upflydyutickchhx")
    public suspend
    fun mobileNetwork(argument: suspend MobileNetworkResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = MobileNetworkResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mobileNetwork = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggpndxjpevwaiejy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("calgprghmibkaogd")
    public suspend fun simGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ljjlnnggtbxmbkee")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mtejvtshxlkxomsl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SimGroupArgs = SimGroupArgs(
        encryptionKey = encryptionKey,
        identity = identity,
        location = location,
        mobileNetwork = mobileNetwork,
        resourceGroupName = resourceGroupName,
        simGroupName = simGroupName,
        tags = tags,
    )
}
