@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
 */
public enum class BillingSku(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.BillingSku,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.BillingSku> {
    /**
     * 100 Mbps, 20 active SIMs plan, 2 RANs
     */
    G0(com.pulumi.azurenative.mobilenetwork.enums.BillingSku.G0),

    /**
     * 1 Gbps, 100 active SIMs plan, 5 RANs
     */
    G1(com.pulumi.azurenative.mobilenetwork.enums.BillingSku.G1),

    /**
     * 2 Gbps, 200 active SIMs plan, 10 RANs
     */
    G2(com.pulumi.azurenative.mobilenetwork.enums.BillingSku.G2),

    /**
     * 5 Gbps, 500 active SIMs plan
     */
    G5(com.pulumi.azurenative.mobilenetwork.enums.BillingSku.G5),

    /**
     * 10 Gbps, 1000 active SIMs plan
     */
    G10(com.pulumi.azurenative.mobilenetwork.enums.BillingSku.G10),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.BillingSku = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.BillingSku): BillingSku =
            BillingSku.values().first { it.javaValue == javaType }
    }
}
