@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether NAPT is enabled for connections to this attached data network.
 */
public enum class NaptEnabled(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled> {
    /**
     * NAPT is enabled
     */
    Enabled(com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled.Enabled),

    /**
     * NAPT is disabled
     */
    Disabled(com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.NaptEnabled):
            NaptEnabled = NaptEnabled.values().first { it.javaValue == javaType }
    }
}
