@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.AmbrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Aggregate maximum bit rate.
 * @property downlink Downlink bit rate.
 * @property uplink Uplink bit rate.
 */
public data class AmbrArgs(
    public val downlink: Output<String>,
    public val uplink: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.AmbrArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.AmbrArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.AmbrArgs.builder()
            .downlink(downlink.applyValue({ args0 -> args0 }))
            .uplink(uplink.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmbrArgs].
 */
@PulumiTagMarker
public class AmbrArgsBuilder internal constructor() {
    private var downlink: Output<String>? = null

    private var uplink: Output<String>? = null

    /**
     * @param value Downlink bit rate.
     */
    @JvmName("mbbmmvhiibfjoyek")
    public suspend fun downlink(`value`: Output<String>) {
        this.downlink = value
    }

    /**
     * @param value Uplink bit rate.
     */
    @JvmName("peibkbelakedjjhl")
    public suspend fun uplink(`value`: Output<String>) {
        this.uplink = value
    }

    /**
     * @param value Downlink bit rate.
     */
    @JvmName("kahkvstoncckofaq")
    public suspend fun downlink(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.downlink = mapped
    }

    /**
     * @param value Uplink bit rate.
     */
    @JvmName("uwmstcieytplcxjt")
    public suspend fun uplink(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uplink = mapped
    }

    internal fun build(): AmbrArgs = AmbrArgs(
        downlink = downlink ?: throw PulumiNullFieldException("downlink"),
        uplink = uplink ?: throw PulumiNullFieldException("uplink"),
    )
}
