@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkConfigurationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PduSessionType
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionCapability
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionVulnerability
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Settings controlling data network use
 * @property additionalAllowedSessionTypes Allowed session types in addition to the default session type. Must not duplicate the default session type.
 * @property allocationAndRetentionPriorityLevel Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property allowedServices List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
 * @property dataNetwork A reference to the data network that these settings apply to. The data network must be in the same location as the SIM policy.
 * @property defaultSessionType The default PDU session type, which is used if the UE does not request a specific session type.
 * @property fiveQi Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
 * @property maximumNumberOfBufferedPackets The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
 * @property preemptionCapability Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property preemptionVulnerability Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property sessionAmbr Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
 */
public data class DataNetworkConfigurationArgs(
    public val additionalAllowedSessionTypes: Output<List<Either<String, PduSessionType>>>? = null,
    public val allocationAndRetentionPriorityLevel: Output<Int>? = null,
    public val allowedServices: Output<List<ServiceResourceIdArgs>>,
    public val dataNetwork: Output<DataNetworkResourceIdArgs>,
    public val defaultSessionType: Output<Either<String, PduSessionType>>? = null,
    public val fiveQi: Output<Int>? = null,
    public val maximumNumberOfBufferedPackets: Output<Int>? = null,
    public val preemptionCapability: Output<Either<String, PreemptionCapability>>? = null,
    public val preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null,
    public val sessionAmbr: Output<AmbrArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkConfigurationArgs.builder()
            .additionalAllowedSessionTypes(
                additionalAllowedSessionTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .allocationAndRetentionPriorityLevel(
                allocationAndRetentionPriorityLevel?.applyValue({ args0 ->
                    args0
                }),
            )
            .allowedServices(
                allowedServices.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataNetwork(dataNetwork.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultSessionType(
                defaultSessionType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .fiveQi(fiveQi?.applyValue({ args0 -> args0 }))
            .maximumNumberOfBufferedPackets(maximumNumberOfBufferedPackets?.applyValue({ args0 -> args0 }))
            .preemptionCapability(
                preemptionCapability?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .preemptionVulnerability(
                preemptionVulnerability?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sessionAmbr(sessionAmbr.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class DataNetworkConfigurationArgsBuilder internal constructor() {
    private var additionalAllowedSessionTypes: Output<List<Either<String, PduSessionType>>>? = null

    private var allocationAndRetentionPriorityLevel: Output<Int>? = null

    private var allowedServices: Output<List<ServiceResourceIdArgs>>? = null

    private var dataNetwork: Output<DataNetworkResourceIdArgs>? = null

    private var defaultSessionType: Output<Either<String, PduSessionType>>? = null

    private var fiveQi: Output<Int>? = null

    private var maximumNumberOfBufferedPackets: Output<Int>? = null

    private var preemptionCapability: Output<Either<String, PreemptionCapability>>? = null

    private var preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null

    private var sessionAmbr: Output<AmbrArgs>? = null

    /**
     * @param value Allowed session types in addition to the default session type. Must not duplicate the default session type.
     */
    @JvmName("bhevrirqismwdotw")
    public suspend
    fun additionalAllowedSessionTypes(`value`: Output<List<Either<String, PduSessionType>>>) {
        this.additionalAllowedSessionTypes = value
    }

    @JvmName("vorljmesnpqtnets")
    public suspend fun additionalAllowedSessionTypes(
        vararg
        values: Output<Either<String, PduSessionType>>,
    ) {
        this.additionalAllowedSessionTypes = Output.all(values.asList())
    }

    /**
     * @param values Allowed session types in addition to the default session type. Must not duplicate the default session type.
     */
    @JvmName("shegtmurnmqoqloc")
    public suspend
    fun additionalAllowedSessionTypes(values: List<Output<Either<String, PduSessionType>>>) {
        this.additionalAllowedSessionTypes = Output.all(values)
    }

    /**
     * @param value Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("gckfkforivinpkum")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Output<Int>) {
        this.allocationAndRetentionPriorityLevel = value
    }

    /**
     * @param value List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("dbdcxfctpmcnpxts")
    public suspend fun allowedServices(`value`: Output<List<ServiceResourceIdArgs>>) {
        this.allowedServices = value
    }

    @JvmName("xsvpevbjsamypyvd")
    public suspend fun allowedServices(vararg values: Output<ServiceResourceIdArgs>) {
        this.allowedServices = Output.all(values.asList())
    }

    /**
     * @param values List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("aabvyvijxpdmtadi")
    public suspend fun allowedServices(values: List<Output<ServiceResourceIdArgs>>) {
        this.allowedServices = Output.all(values)
    }

    /**
     * @param value A reference to the data network that these settings apply to. The data network must be in the same location as the SIM policy.
     */
    @JvmName("htkvaiywmtaluvqc")
    public suspend fun dataNetwork(`value`: Output<DataNetworkResourceIdArgs>) {
        this.dataNetwork = value
    }

    /**
     * @param value The default PDU session type, which is used if the UE does not request a specific session type.
     */
    @JvmName("yqxiyptkomrvhoug")
    public suspend fun defaultSessionType(`value`: Output<Either<String, PduSessionType>>) {
        this.defaultSessionType = value
    }

    /**
     * @param value Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("sviiollionkmehvb")
    public suspend fun fiveQi(`value`: Output<Int>) {
        this.fiveQi = value
    }

    /**
     * @param value The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
     */
    @JvmName("upacivdrmesetvbr")
    public suspend fun maximumNumberOfBufferedPackets(`value`: Output<Int>) {
        this.maximumNumberOfBufferedPackets = value
    }

    /**
     * @param value Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("hpdhlqqrknaasrpv")
    public suspend fun preemptionCapability(`value`: Output<Either<String, PreemptionCapability>>) {
        this.preemptionCapability = value
    }

    /**
     * @param value Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("jklrdtotxbcisaxr")
    public suspend
    fun preemptionVulnerability(`value`: Output<Either<String, PreemptionVulnerability>>) {
        this.preemptionVulnerability = value
    }

    /**
     * @param value Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
     */
    @JvmName("ywbsyweostaxopmn")
    public suspend fun sessionAmbr(`value`: Output<AmbrArgs>) {
        this.sessionAmbr = value
    }

    /**
     * @param value Allowed session types in addition to the default session type. Must not duplicate the default session type.
     */
    @JvmName("cqtbbbxwjlwcvgmq")
    public suspend fun additionalAllowedSessionTypes(`value`: List<Either<String, PduSessionType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalAllowedSessionTypes = mapped
    }

    /**
     * @param values Allowed session types in addition to the default session type. Must not duplicate the default session type.
     */
    @JvmName("vttennurfasjxibk")
    public suspend fun additionalAllowedSessionTypes(vararg values: Either<String, PduSessionType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalAllowedSessionTypes = mapped
    }

    /**
     * @param value Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("wpewhjrfobolelnc")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationAndRetentionPriorityLevel = mapped
    }

    /**
     * @param value List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("yxhcedsyofoljgly")
    public suspend fun allowedServices(`value`: List<ServiceResourceIdArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedServices = mapped
    }

    /**
     * @param argument List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("fyfiftgufqrqgblc")
    public suspend
    fun allowedServices(argument: List<suspend ServiceResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedServices = mapped
    }

    /**
     * @param argument List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("qnvdmiqqbjusyvgb")
    public suspend fun allowedServices(
        vararg
        argument: suspend ServiceResourceIdArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedServices = mapped
    }

    /**
     * @param argument List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("poumeoetporbkpjl")
    public suspend fun allowedServices(argument: suspend ServiceResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allowedServices = mapped
    }

    /**
     * @param values List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
     */
    @JvmName("rlnvsbskjaydwvfe")
    public suspend fun allowedServices(vararg values: ServiceResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedServices = mapped
    }

    /**
     * @param value A reference to the data network that these settings apply to. The data network must be in the same location as the SIM policy.
     */
    @JvmName("mfgtxqqgumoualkd")
    public suspend fun dataNetwork(`value`: DataNetworkResourceIdArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataNetwork = mapped
    }

    /**
     * @param argument A reference to the data network that these settings apply to. The data network must be in the same location as the SIM policy.
     */
    @JvmName("qjcjhkoldiitqjqj")
    public suspend fun dataNetwork(argument: suspend DataNetworkResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = DataNetworkResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataNetwork = mapped
    }

    /**
     * @param value The default PDU session type, which is used if the UE does not request a specific session type.
     */
    @JvmName("fkhpnaxqteadiird")
    public suspend fun defaultSessionType(`value`: Either<String, PduSessionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSessionType = mapped
    }

    /**
     * @param value The default PDU session type, which is used if the UE does not request a specific session type.
     */
    @JvmName("phkrlhrrsycjhdma")
    public fun defaultSessionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PduSessionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSessionType = mapped
    }

    /**
     * @param value The default PDU session type, which is used if the UE does not request a specific session type.
     */
    @JvmName("gnrunnhlypnaycas")
    public fun defaultSessionType(`value`: PduSessionType) {
        val toBeMapped = Either.ofRight<String, PduSessionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSessionType = mapped
    }

    /**
     * @param value Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("gngtohnyvbyytqxm")
    public suspend fun fiveQi(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fiveQi = mapped
    }

    /**
     * @param value The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
     */
    @JvmName("leiadosskqrltkqs")
    public suspend fun maximumNumberOfBufferedPackets(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumNumberOfBufferedPackets = mapped
    }

    /**
     * @param value Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("flhwblqqvanutnrx")
    public suspend fun preemptionCapability(`value`: Either<String, PreemptionCapability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("ojpgyhltpgkyvman")
    public fun preemptionCapability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("qvgwicfuuryyqgcw")
    public fun preemptionCapability(`value`: PreemptionCapability) {
        val toBeMapped = Either.ofRight<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("slcwjdjifgjwdsog")
    public suspend fun preemptionVulnerability(`value`: Either<String, PreemptionVulnerability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("dprgprjnxnucmdmv")
    public fun preemptionVulnerability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("cxeflgijupmpgsxx")
    public fun preemptionVulnerability(`value`: PreemptionVulnerability) {
        val toBeMapped = Either.ofRight<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
     */
    @JvmName("sajikpnqmktvtxfy")
    public suspend fun sessionAmbr(`value`: AmbrArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAmbr = mapped
    }

    /**
     * @param argument Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
     */
    @JvmName("gyyeecaenyyxnsfb")
    public suspend fun sessionAmbr(argument: suspend AmbrArgsBuilder.() -> Unit) {
        val toBeMapped = AmbrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sessionAmbr = mapped
    }

    internal fun build(): DataNetworkConfigurationArgs = DataNetworkConfigurationArgs(
        additionalAllowedSessionTypes = additionalAllowedSessionTypes,
        allocationAndRetentionPriorityLevel = allocationAndRetentionPriorityLevel,
        allowedServices = allowedServices ?: throw PulumiNullFieldException("allowedServices"),
        dataNetwork = dataNetwork ?: throw PulumiNullFieldException("dataNetwork"),
        defaultSessionType = defaultSessionType,
        fiveQi = fiveQi,
        maximumNumberOfBufferedPackets = maximumNumberOfBufferedPackets,
        preemptionCapability = preemptionCapability,
        preemptionVulnerability = preemptionVulnerability,
        sessionAmbr = sessionAmbr ?: throw PulumiNullFieldException("sessionAmbr"),
    )
}
