@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.DiagnosticsUploadConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for uploading packet core diagnostics.
 * @property storageAccountContainerUrl The Storage Account Container URL to upload diagnostics to.
 */
public data class DiagnosticsUploadConfigurationArgs(
    public val storageAccountContainerUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.DiagnosticsUploadConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilenetwork.inputs.DiagnosticsUploadConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.DiagnosticsUploadConfigurationArgs.builder()
            .storageAccountContainerUrl(storageAccountContainerUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiagnosticsUploadConfigurationArgs].
 */
@PulumiTagMarker
public class DiagnosticsUploadConfigurationArgsBuilder internal constructor() {
    private var storageAccountContainerUrl: Output<String>? = null

    /**
     * @param value The Storage Account Container URL to upload diagnostics to.
     */
    @JvmName("ikjabdpcjoybccna")
    public suspend fun storageAccountContainerUrl(`value`: Output<String>) {
        this.storageAccountContainerUrl = value
    }

    /**
     * @param value The Storage Account Container URL to upload diagnostics to.
     */
    @JvmName("vmultfqloysbbisj")
    public suspend fun storageAccountContainerUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountContainerUrl = mapped
    }

    internal fun build(): DiagnosticsUploadConfigurationArgs = DiagnosticsUploadConfigurationArgs(
        storageAccountContainerUrl = storageAccountContainerUrl ?: throw
            PulumiNullFieldException("storageAccountContainerUrl"),
    )
}
