@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCapturePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property packetCaptureName The name of the packet capture session.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPacketCapturePlainArgs(
    public val packetCaptureName: String,
    public val packetCoreControlPlaneName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCapturePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCapturePlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCapturePlainArgs.builder()
            .packetCaptureName(packetCaptureName.let({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPacketCapturePlainArgs].
 */
@PulumiTagMarker
public class GetPacketCapturePlainArgsBuilder internal constructor() {
    private var packetCaptureName: String? = null

    private var packetCoreControlPlaneName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("qgupghbnlgjiqnjb")
    public suspend fun packetCaptureName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCaptureName = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("hxndnpidmdoitgth")
    public suspend fun packetCoreControlPlaneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kessdojgiqquuquy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPacketCapturePlainArgs = GetPacketCapturePlainArgs(
        packetCaptureName = packetCaptureName ?: throw PulumiNullFieldException("packetCaptureName"),
        packetCoreControlPlaneName = packetCoreControlPlaneName ?: throw
            PulumiNullFieldException("packetCoreControlPlaneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
