@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The name of the mobile network site.
 */
public data class GetSitePlainArgs(
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetSitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetSitePlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetSitePlainArgs.builder()
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSitePlainArgs].
 */
@PulumiTagMarker
public class GetSitePlainArgsBuilder internal constructor() {
    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("fpoeckcpygpitpem")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gjqkrjedmnhhsntt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the mobile network site.
     */
    @JvmName("qujmpcspdwqdenms")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetSitePlainArgs = GetSitePlainArgs(
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
    )
}
