@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.InstallationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.DesiredInstallationState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The installation state of the packet core.
 * @property desiredState The desired installation state
 */
public data class InstallationArgs(
    public val desiredState: Output<Either<String, DesiredInstallationState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.InstallationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.InstallationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.InstallationArgs.builder()
            .desiredState(
                desiredState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstallationArgs].
 */
@PulumiTagMarker
public class InstallationArgsBuilder internal constructor() {
    private var desiredState: Output<Either<String, DesiredInstallationState>>? = null

    /**
     * @param value The desired installation state
     */
    @JvmName("vllrficumwdwxplp")
    public suspend fun desiredState(`value`: Output<Either<String, DesiredInstallationState>>) {
        this.desiredState = value
    }

    /**
     * @param value The desired installation state
     */
    @JvmName("epvwwmmucxdrtwji")
    public suspend fun desiredState(`value`: Either<String, DesiredInstallationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value The desired installation state
     */
    @JvmName("btcknbikanyfmyra")
    public fun desiredState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DesiredInstallationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value The desired installation state
     */
    @JvmName("hvyqekechvekhrjn")
    public fun desiredState(`value`: DesiredInstallationState) {
        val toBeMapped = Either.ofRight<String, DesiredInstallationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    internal fun build(): InstallationArgs = InstallationArgs(
        desiredState = desiredState,
    )
}
