@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.KeyVaultKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure key vault key.
 * @property keyUrl The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
 */
public data class KeyVaultKeyArgs(
    public val keyUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.KeyVaultKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.KeyVaultKeyArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.KeyVaultKeyArgs.builder()
            .keyUrl(keyUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultKeyArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyArgsBuilder internal constructor() {
    private var keyUrl: Output<String>? = null

    /**
     * @param value The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
     */
    @JvmName("vtminqvoavxxiolv")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
     */
    @JvmName("qbubcdqwjvkwstdg")
    public suspend fun keyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    internal fun build(): KeyVaultKeyArgs = KeyVaultKeyArgs(
        keyUrl = keyUrl,
    )
}
