@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMobileNetworkSimIdsPlainArgs(
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimIdsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimIdsPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimIdsPlainArgs.builder()
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMobileNetworkSimIdsPlainArgs].
 */
@PulumiTagMarker
public class ListMobileNetworkSimIdsPlainArgsBuilder internal constructor() {
    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("ikcirajkmgfucllp")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwymxxqmqosjxgmn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMobileNetworkSimIdsPlainArgs = ListMobileNetworkSimIdsPlainArgs(
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
