@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.MobileNetworkResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a mobile network resource.
 * @property id Mobile network resource ID.
 */
public data class MobileNetworkResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.MobileNetworkResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.MobileNetworkResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.MobileNetworkResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MobileNetworkResourceIdArgs].
 */
@PulumiTagMarker
public class MobileNetworkResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Mobile network resource ID.
     */
    @JvmName("ftuimsxyjhdjbcip")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Mobile network resource ID.
     */
    @JvmName("genvlupyyqyfrkpw")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): MobileNetworkResourceIdArgs = MobileNetworkResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
