@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single-network slice selection assistance information (S-NSSAI).
 * @property sd Slice differentiator (SD).
 * @property sst Slice/service type (SST).
 */
public data class SnssaiArgs(
    public val sd: Output<String>? = null,
    public val sst: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs.builder()
            .sd(sd?.applyValue({ args0 -> args0 }))
            .sst(sst.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnssaiArgs].
 */
@PulumiTagMarker
public class SnssaiArgsBuilder internal constructor() {
    private var sd: Output<String>? = null

    private var sst: Output<Int>? = null

    /**
     * @param value Slice differentiator (SD).
     */
    @JvmName("nhqjqgqgxdekpnqn")
    public suspend fun sd(`value`: Output<String>) {
        this.sd = value
    }

    /**
     * @param value Slice/service type (SST).
     */
    @JvmName("ymdovdbltjkplyxi")
    public suspend fun sst(`value`: Output<Int>) {
        this.sst = value
    }

    /**
     * @param value Slice differentiator (SD).
     */
    @JvmName("wnkwgrmuefmvnige")
    public suspend fun sd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sd = mapped
    }

    /**
     * @param value Slice/service type (SST).
     */
    @JvmName("jtfiplbawnacspjs")
    public suspend fun sst(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sst = mapped
    }

    internal fun build(): SnssaiArgs = SnssaiArgs(
        sd = sd,
        sst = sst ?: throw PulumiNullFieldException("sst"),
    )
}
