@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for uploading packet core diagnostics.
 * @property storageAccountContainerUrl The Storage Account Container URL to upload diagnostics to.
 */
public data class DiagnosticsUploadConfigurationResponse(
    public val storageAccountContainerUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.DiagnosticsUploadConfigurationResponse):
            DiagnosticsUploadConfigurationResponse = DiagnosticsUploadConfigurationResponse(
            storageAccountContainerUrl = javaType.storageAccountContainerUrl(),
        )
    }
}
