@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Mobile network resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the mobile network resource.
 * @property publicLandMobileNetworkIdentifier The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
 * @property serviceKey The mobile network resource identifier
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMobileNetworkResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val publicLandMobileNetworkIdentifier: PlmnIdResponse,
    public val serviceKey: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetMobileNetworkResult):
            GetMobileNetworkResult = GetMobileNetworkResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicLandMobileNetworkIdentifier = javaType.publicLandMobileNetworkIdentifier().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlmnIdResponse.Companion.toKotlin(args0)
            }),
            serviceKey = javaType.serviceKey(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
