@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data flow policy rule QoS policy
 * @property allocationAndRetentionPriorityLevel QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property fiveQi 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
 * @property guaranteedBitRate The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the data flow policy rule that uses this QoS definition.
 * @property maximumBitRate The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
 * @property preemptionCapability QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property preemptionVulnerability QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 */
public data class PccRuleQosPolicyResponse(
    public val allocationAndRetentionPriorityLevel: Int? = null,
    public val fiveQi: Int? = null,
    public val guaranteedBitRate: AmbrResponse? = null,
    public val maximumBitRate: AmbrResponse,
    public val preemptionCapability: String? = null,
    public val preemptionVulnerability: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PccRuleQosPolicyResponse):
            PccRuleQosPolicyResponse = PccRuleQosPolicyResponse(
            allocationAndRetentionPriorityLevel = javaType.allocationAndRetentionPriorityLevel().map({ args0 ->
                args0
            }).orElse(null),
            fiveQi = javaType.fiveQi().map({ args0 -> args0 }).orElse(null),
            guaranteedBitRate = javaType.guaranteedBitRate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maximumBitRate = javaType.maximumBitRate().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse.Companion.toKotlin(args0)
            }),
            preemptionCapability = javaType.preemptionCapability().map({ args0 -> args0 }).orElse(null),
            preemptionVulnerability = javaType.preemptionVulnerability().map({ args0 -> args0 }).orElse(null),
        )
    }
}
