@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Single-network slice selection assistance information (S-NSSAI).
 * @property sd Slice differentiator (SD).
 * @property sst Slice/service type (SST).
 */
public data class SnssaiResponse(
    public val sd: String? = null,
    public val sst: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.SnssaiResponse):
            SnssaiResponse = SnssaiResponse(
            sd = javaType.sd().map({ args0 -> args0 }).orElse(null),
            sst = javaType.sst(),
        )
    }
}
