@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Access and Mobility Function (AMF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### AmfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var amfDeployment = new AzureNative.MobilePacketCore.AmfDeployment("amfDeployment", new()
 *     {
 *         AmfDeploymentName = "amfDeployment1",
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewAmfDeployment(ctx, "amfDeployment", &mobilepacketcore.AmfDeploymentArgs{
 * 			AmfDeploymentName:   pulumi.String("amfDeployment1"),
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.AmfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var amfDeployment = new AmfDeployment("amfDeployment", AmfDeploymentArgs.builder()
 *             .amfDeploymentName("amfDeployment1")
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:AmfDeployment amfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/amfDeployments/{amfDeploymentName}
 * ```
 * @property amfDeploymentName The name of the AMF Deployment
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core AMF component parameters
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secretsParameters Azure for Operators 5G Core AMF secrets parameters
 * @property tags Resource tags.
 */
public data class AmfDeploymentArgs(
    public val amfDeploymentName: Output<String>? = null,
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretsParameters: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs =
        com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs.builder()
            .amfDeploymentName(amfDeploymentName?.applyValue({ args0 -> args0 }))
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(componentParameters?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretsParameters(secretsParameters?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AmfDeploymentArgs].
 */
@PulumiTagMarker
public class AmfDeploymentArgsBuilder internal constructor() {
    private var amfDeploymentName: Output<String>? = null

    private var clusterService: Output<String>? = null

    private var componentParameters: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretsParameters: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the AMF Deployment
     */
    @JvmName("tbqxauhbnvmwnhdd")
    public suspend fun amfDeploymentName(`value`: Output<String>) {
        this.amfDeploymentName = value
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("uxyxholihrqknbsv")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core AMF component parameters
     */
    @JvmName("gxtlmcsatoomkdcc")
    public suspend fun componentParameters(`value`: Output<String>) {
        this.componentParameters = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xmsxjagqbgrmabrc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bbadkwnubskgmvhu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure for Operators 5G Core AMF secrets parameters
     */
    @JvmName("ovitysqwwmcqfrld")
    public suspend fun secretsParameters(`value`: Output<String>) {
        this.secretsParameters = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mtdvnrnsoqohjlqs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the AMF Deployment
     */
    @JvmName("gxrxkteeqwobmsfk")
    public suspend fun amfDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amfDeploymentName = mapped
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("khigofjiumwdgvsg")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core AMF component parameters
     */
    @JvmName("sjkmrjeguclskhvq")
    public suspend fun componentParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yrfvpxurnvosrtgg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kbmgnrpkmcfillie")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure for Operators 5G Core AMF secrets parameters
     */
    @JvmName("yotdartxtibplaod")
    public suspend fun secretsParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsParameters = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qyytudwcfpkgjmjl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("alnionpnjmdtjxuw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AmfDeploymentArgs = AmfDeploymentArgs(
        amfDeploymentName = amfDeploymentName,
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        resourceGroupName = resourceGroupName,
        secretsParameters = secretsParameters,
        tags = tags,
    )
}
