@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin as operationalStatusResponseToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NrfDeployment].
 */
@PulumiTagMarker
public class NrfDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NrfDeploymentArgs = NrfDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NrfDeploymentArgsBuilder.() -> Unit) {
        val builder = NrfDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NrfDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.mobilepacketcore.NrfDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NrfDeployment(builtJavaResource)
    }
}

/**
 * Azure for Operators 5G Core Network Repository Function (NRF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### NrfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nrfDeployment = new AzureNative.MobilePacketCore.NrfDeployment("nrfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         NrfDeploymentName = "nrfDeployment1",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewNrfDeployment(ctx, "nrfDeployment", &mobilepacketcore.NrfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			NrfDeploymentName:   pulumi.String("nrfDeployment1"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.NrfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nrfDeployment = new NrfDeployment("nrfDeployment", NrfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .nrfDeploymentName("nrfDeployment1")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:NrfDeployment nrfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/nrfDeployments/{nrfDeploymentName}
 * ```
 */
public class NrfDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilepacketcore.NrfDeployment,
) : KotlinCustomResource(javaResource, NrfDeploymentMapper) {
    /**
     * Reference to cluster where the Network Function is deployed
     */
    public val clusterService: Output<String>
        get() = javaResource.clusterService().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core NRF component parameters
     */
    public val componentParameters: Output<String>?
        get() = javaResource.componentParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operational status
     */
    public val operationalStatus: Output<OperationalStatusResponse>
        get() = javaResource.operationalStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                operationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Release version. This is inherited from the cluster
     */
    public val releaseVersion: Output<String>
        get() = javaResource.releaseVersion().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core NRF secrets parameters
     */
    public val secretsParameters: Output<String>?
        get() = javaResource.secretsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NrfDeploymentMapper : ResourceMapper<NrfDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilepacketcore.NrfDeployment::class == javaResource::class

    override fun map(javaResource: Resource): NrfDeployment = NrfDeployment(
        javaResource as
            com.pulumi.azurenative.mobilepacketcore.NrfDeployment,
    )
}

/**
 * @see [NrfDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NrfDeployment].
 */
public suspend fun nrfDeployment(
    name: String,
    block: suspend NrfDeploymentResourceBuilder.() -> Unit,
): NrfDeployment {
    val builder = NrfDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NrfDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nrfDeployment(name: String): NrfDeployment {
    val builder = NrfDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
