@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Network Repository Function (NRF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### NrfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nrfDeployment = new AzureNative.MobilePacketCore.NrfDeployment("nrfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         NrfDeploymentName = "nrfDeployment1",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewNrfDeployment(ctx, "nrfDeployment", &mobilepacketcore.NrfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			NrfDeploymentName:   pulumi.String("nrfDeployment1"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.NrfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nrfDeployment = new NrfDeployment("nrfDeployment", NrfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .nrfDeploymentName("nrfDeployment1")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:NrfDeployment nrfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/nrfDeployments/{nrfDeploymentName}
 * ```
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core NRF component parameters
 * @property location The geo-location where the resource lives
 * @property nrfDeploymentName The name of the NrfDeployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secretsParameters Azure for Operators 5G Core NRF secrets parameters
 * @property tags Resource tags.
 */
public data class NrfDeploymentArgs(
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<String>? = null,
    public val location: Output<String>? = null,
    public val nrfDeploymentName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretsParameters: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs =
        com.pulumi.azurenative.mobilepacketcore.NrfDeploymentArgs.builder()
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(componentParameters?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .nrfDeploymentName(nrfDeploymentName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretsParameters(secretsParameters?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NrfDeploymentArgs].
 */
@PulumiTagMarker
public class NrfDeploymentArgsBuilder internal constructor() {
    private var clusterService: Output<String>? = null

    private var componentParameters: Output<String>? = null

    private var location: Output<String>? = null

    private var nrfDeploymentName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretsParameters: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("mocwbbaxwfwjptkh")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core NRF component parameters
     */
    @JvmName("brhhvwilpmoljtyh")
    public suspend fun componentParameters(`value`: Output<String>) {
        this.componentParameters = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aliejnhjqjlcvolv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the NrfDeployment
     */
    @JvmName("aomnedwxowvooblb")
    public suspend fun nrfDeploymentName(`value`: Output<String>) {
        this.nrfDeploymentName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mmqeisykohocjykp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure for Operators 5G Core NRF secrets parameters
     */
    @JvmName("pjbukdflycqthqwn")
    public suspend fun secretsParameters(`value`: Output<String>) {
        this.secretsParameters = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yurtmymdxffgqblk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("atcnjgskhbaqlsmp")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core NRF component parameters
     */
    @JvmName("kxcwpoydirhvpswr")
    public suspend fun componentParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("slesrlphwwcpbmrj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the NrfDeployment
     */
    @JvmName("pmpgauiakgqowmvc")
    public suspend fun nrfDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nrfDeploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xcvsfmswukvvwsyv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure for Operators 5G Core NRF secrets parameters
     */
    @JvmName("sndebrwqqpyulxcw")
    public suspend fun secretsParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsParameters = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("voamhfrbasllngfq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hfoowvdmqllavwgi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NrfDeploymentArgs = NrfDeploymentArgs(
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        nrfDeploymentName = nrfDeploymentName,
        resourceGroupName = resourceGroupName,
        secretsParameters = secretsParameters,
        tags = tags,
    )
}
