@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.ObservabilityServiceArgs.builder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.QualifiedComponentDeploymentParametersArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.QualifiedComponentDeploymentParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Observability Service Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### ObservabilityServices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var observabilityService = new AzureNative.MobilePacketCore.ObservabilityService("observabilityService", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = new[]
 *         {
 *             new AzureNative.MobilePacketCore.Inputs.QualifiedComponentDeploymentParametersArgs
 *             {
 *                 Parameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *                 Secrets = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *                 Type = "fed-crds",
 *             },
 *         },
 *         Location = "eastus",
 *         ObservabilityServiceName = "observabilityService1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewObservabilityService(ctx, "observabilityService", &mobilepacketcore.ObservabilityServiceArgs{
 * 			ClusterService: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: []mobilepacketcore.QualifiedComponentDeploymentParametersArgs{
 * 				{
 * 					Parameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 					Secrets:    pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 					Type:       pulumi.String("fed-crds"),
 * 				},
 * 			},
 * 			Location:                 pulumi.String("eastus"),
 * 			ObservabilityServiceName: pulumi.String("observabilityService1"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.ObservabilityService;
 * import com.pulumi.azurenative.mobilepacketcore.ObservabilityServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var observabilityService = new ObservabilityService("observabilityService", ObservabilityServiceArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters(Map.ofEntries(
 *                 Map.entry("parameters", "{\"global\": {\"registry\": {\"docker\": []}}}"),
 *                 Map.entry("secrets", "{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 *                 Map.entry("type", "fed-crds")
 *             ))
 *             .location("eastus")
 *             .observabilityServiceName("observabilityService1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:ObservabilityService observabilityService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/observabilityServices/{observabilityServiceName}
 * ```
 * @property clusterService Reference to cluster where the observability components are deployed
 * @property componentParameters Azure for Operators 5G Core Observability component parameters.  One set per component type
 * @property location The geo-location where the resource lives
 * @property observabilityServiceName The name of the Observability Service
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ObservabilityServiceArgs(
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<List<QualifiedComponentDeploymentParametersArgs>>? = null,
    public val location: Output<String>? = null,
    public val observabilityServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.ObservabilityServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.ObservabilityServiceArgs =
        com.pulumi.azurenative.mobilepacketcore.ObservabilityServiceArgs.builder()
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(
                componentParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .observabilityServiceName(observabilityServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ObservabilityServiceArgs].
 */
@PulumiTagMarker
public class ObservabilityServiceArgsBuilder internal constructor() {
    private var clusterService: Output<String>? = null

    private var componentParameters: Output<List<QualifiedComponentDeploymentParametersArgs>>? = null

    private var location: Output<String>? = null

    private var observabilityServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Reference to cluster where the observability components are deployed
     */
    @JvmName("nbouriryireskdpu")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("dkckqbbmgmyjoegv")
    public suspend
    fun componentParameters(`value`: Output<List<QualifiedComponentDeploymentParametersArgs>>) {
        this.componentParameters = value
    }

    @JvmName("hvheseedkejfqtbw")
    public suspend fun componentParameters(
        vararg
        values: Output<QualifiedComponentDeploymentParametersArgs>,
    ) {
        this.componentParameters = Output.all(values.asList())
    }

    /**
     * @param values Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("vqknidrvrxohyjmo")
    public suspend
    fun componentParameters(values: List<Output<QualifiedComponentDeploymentParametersArgs>>) {
        this.componentParameters = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("abgvbtopoqxjehek")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Observability Service
     */
    @JvmName("ixbsviuvmuncrwfj")
    public suspend fun observabilityServiceName(`value`: Output<String>) {
        this.observabilityServiceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nmdoecgixehoxoom")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fppfavkbctjnbwbv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Reference to cluster where the observability components are deployed
     */
    @JvmName("paycrfkhfcfckhqp")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("sqrhrphntmvcpfxm")
    public suspend
    fun componentParameters(`value`: List<QualifiedComponentDeploymentParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("sdbgjafvyocqlctl")
    public suspend
    fun componentParameters(argument: List<suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("gafynbykvgqqrjtj")
    public suspend fun componentParameters(
        vararg
        argument: suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("ppknfyfqrmtmdaln")
    public suspend
    fun componentParameters(argument: suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param values Azure for Operators 5G Core Observability component parameters.  One set per component type
     */
    @JvmName("jirviwxljvpncrmq")
    public suspend fun componentParameters(
        vararg
        values: QualifiedComponentDeploymentParametersArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xhgnoqwfhcmqufyf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Observability Service
     */
    @JvmName("kkumaqdvxbuldmab")
    public suspend fun observabilityServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qukcjlsgnmwckaig")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fqynfnqximrrunhg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eldthmexoscxrohg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ObservabilityServiceArgs = ObservabilityServiceArgs(
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        observabilityServiceName = observabilityServiceName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
