@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetObservabilityServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property observabilityServiceName The name of the Observability Service
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetObservabilityServicePlainArgs(
    public val observabilityServiceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetObservabilityServicePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilepacketcore.inputs.GetObservabilityServicePlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetObservabilityServicePlainArgs.builder()
            .observabilityServiceName(observabilityServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetObservabilityServicePlainArgs].
 */
@PulumiTagMarker
public class GetObservabilityServicePlainArgsBuilder internal constructor() {
    private var observabilityServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Observability Service
     */
    @JvmName("pptwvgaxkvsbvgvx")
    public suspend fun observabilityServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.observabilityServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("udwcpoxxjlfwtkud")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetObservabilityServicePlainArgs = GetObservabilityServicePlainArgs(
        observabilityServiceName = observabilityServiceName ?: throw
            PulumiNullFieldException("observabilityServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
