@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetSmfDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property smfDeploymentName The name of the SmfDeployment
 */
public data class GetSmfDeploymentPlainArgs(
    public val resourceGroupName: String,
    public val smfDeploymentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetSmfDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetSmfDeploymentPlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetSmfDeploymentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .smfDeploymentName(smfDeploymentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSmfDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetSmfDeploymentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var smfDeploymentName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("plisrdqraabsytgb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SmfDeployment
     */
    @JvmName("xrwbunriyqanjcdw")
    public suspend fun smfDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.smfDeploymentName = mapped
    }

    internal fun build(): GetSmfDeploymentPlainArgs = GetSmfDeploymentPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        smfDeploymentName = smfDeploymentName ?: throw PulumiNullFieldException("smfDeploymentName"),
    )
}
