@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetUpfDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property upfDeploymentName The name of the UpfDeployment
 */
public data class GetUpfDeploymentPlainArgs(
    public val resourceGroupName: String,
    public val upfDeploymentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetUpfDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetUpfDeploymentPlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetUpfDeploymentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .upfDeploymentName(upfDeploymentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUpfDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetUpfDeploymentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var upfDeploymentName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rdswaoemtrxcbwjj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the UpfDeployment
     */
    @JvmName("cxhtckctjgcaomkn")
    public suspend fun upfDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.upfDeploymentName = mapped
    }

    internal fun build(): GetUpfDeploymentPlainArgs = GetUpfDeploymentPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        upfDeploymentName = upfDeploymentName ?: throw PulumiNullFieldException("upfDeploymentName"),
    )
}
