@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Containerized Network Function (CNF) Qualified Deployment Parameters
 * @property parameters Deployment Parameters
 * @property secrets Deployment secrets
 * @property type Federation Type
 */
public data class QualifiedComponentDeploymentParametersArgs(
    public val parameters: Output<String>? = null,
    public val secrets: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs.builder()
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .secrets(secrets?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QualifiedComponentDeploymentParametersArgs].
 */
@PulumiTagMarker
public class QualifiedComponentDeploymentParametersArgsBuilder internal constructor() {
    private var parameters: Output<String>? = null

    private var secrets: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Deployment Parameters
     */
    @JvmName("jtpyswbvvheihuhe")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Deployment secrets
     */
    @JvmName("lcxyvlydityxenja")
    public suspend fun secrets(`value`: Output<String>) {
        this.secrets = value
    }

    /**
     * @param value Federation Type
     */
    @JvmName("dstvddwpyuqchrcy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Deployment Parameters
     */
    @JvmName("misfcvlysefgenkh")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Deployment secrets
     */
    @JvmName("mscystnhnvsxjoov")
    public suspend fun secrets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Federation Type
     */
    @JvmName("cuvfmyodgaxdmhwh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): QualifiedComponentDeploymentParametersArgs =
        QualifiedComponentDeploymentParametersArgs(
            parameters = parameters,
            secrets = secrets,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
