@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AKS Cluster specific data.
 * @property customLocationId Custom Location resource ID
 * @property type Cluster Type Definitions
 * Expected value is 'Aks'.
 */
public data class ClusterServiceAksClusterDataResponse(
    public val customLocationId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.ClusterServiceAksClusterDataResponse):
            ClusterServiceAksClusterDataResponse = ClusterServiceAksClusterDataResponse(
            customLocationId = javaType.customLocationId(),
            type = javaType.type(),
        )
    }
}
