@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure for Operators 5G Core Cluster Service Resource
 * @property clusterTypeSpecificData Cluster type specific data.  Contents depend on the cluster type
 * @property componentParameters Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
 * @property deploymentType Cluster type (Lab or Production)
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property operationalStatus Operational status
 * @property provisioningState The status of the last operation.
 * @property releaseVersion Azure for Operators 5G Core Release Version.  This is applied to all platform as a service (PaaS) components and running workloads in this cluster
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetClusterServiceResult(
    public val clusterTypeSpecificData:
    Either<ClusterServiceAksClusterDataResponse, ClusterServiceNexusAksClusterDataResponse>,
    public val componentParameters: List<QualifiedComponentDeploymentParametersResponse>,
    public val deploymentType: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val operationalStatus: OperationalStatusResponse,
    public val provisioningState: String,
    public val releaseVersion: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.GetClusterServiceResult):
            GetClusterServiceResult = GetClusterServiceResult(
            clusterTypeSpecificData = javaType.clusterTypeSpecificData().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceAksClusterDataResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceNexusAksClusterDataResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            componentParameters = javaType.componentParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.QualifiedComponentDeploymentParametersResponse.Companion.toKotlin(args0)
                })
            }),
            deploymentType = javaType.deploymentType(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            operationalStatus = javaType.operationalStatus().let({ args0 ->
                com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            releaseVersion = javaType.releaseVersion(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
