@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.AccountArgs.builder
import com.pulumi.azurenative.netapp.kotlin.inputs.AccountEncryptionArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.AccountEncryptionArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.ActiveDirectoryArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.ActiveDirectoryArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * NetApp account resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-07-01, 2022-05-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
 * ## Example Usage
 * ### Accounts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.NetApp.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         ResourceGroupName = "myRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewAccount(ctx, "account", &netapp.AccountArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Account;
 * import com.pulumi.azurenative.netapp.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .resourceGroupName("myRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Accounts_CreateOrUpdateWithActiveDirectory
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.NetApp.Account("account", new()
 *     {
 *         AccountName = "account1",
 *         ActiveDirectories = new[]
 *         {
 *             new AzureNative.NetApp.Inputs.ActiveDirectoryArgs
 *             {
 *                 AesEncryption = true,
 *                 Dns = "10.10.10.3",
 *                 Domain = "10.10.10.3",
 *                 LdapOverTLS = false,
 *                 LdapSigning = false,
 *                 OrganizationalUnit = "OU=Engineering",
 *                 Password = "ad_password",
 *                 Site = "SiteName",
 *                 SmbServerName = "SMBServer",
 *                 Username = "ad_user_name",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "myRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewAccount(ctx, "account", &netapp.AccountArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			ActiveDirectories: []netapp.ActiveDirectoryArgs{
 * 				{
 * 					AesEncryption:      pulumi.Bool(true),
 * 					Dns:                pulumi.String("10.10.10.3"),
 * 					Domain:             pulumi.String("10.10.10.3"),
 * 					LdapOverTLS:        pulumi.Bool(false),
 * 					LdapSigning:        pulumi.Bool(false),
 * 					OrganizationalUnit: pulumi.String("OU=Engineering"),
 * 					Password:           pulumi.String("ad_password"),
 * 					Site:               pulumi.String("SiteName"),
 * 					SmbServerName:      pulumi.String("SMBServer"),
 * 					Username:           pulumi.String("ad_user_name"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Account;
 * import com.pulumi.azurenative.netapp.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("account1")
 *             .activeDirectories(Map.ofEntries(
 *                 Map.entry("aesEncryption", true),
 *                 Map.entry("dns", "10.10.10.3"),
 *                 Map.entry("domain", "10.10.10.3"),
 *                 Map.entry("ldapOverTLS", false),
 *                 Map.entry("ldapSigning", false),
 *                 Map.entry("organizationalUnit", "OU=Engineering"),
 *                 Map.entry("password", "ad_password"),
 *                 Map.entry("site", "SiteName"),
 *                 Map.entry("smbServerName", "SMBServer"),
 *                 Map.entry("username", "ad_user_name")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("myRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Account account1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}
 * ```
 * @property accountName The name of the NetApp account
 * @property activeDirectories Active Directories
 * @property encryption Encryption settings
 * @property identity The identity used for the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val activeDirectories: Output<List<ActiveDirectoryArgs>>? = null,
    public val encryption: Output<AccountEncryptionArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.AccountArgs =
        com.pulumi.azurenative.netapp.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .activeDirectories(
                activeDirectories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var activeDirectories: Output<List<ActiveDirectoryArgs>>? = null

    private var encryption: Output<AccountEncryptionArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("aredsvskmatbvqyb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Active Directories
     */
    @JvmName("vtetvwvfvkhdxlep")
    public suspend fun activeDirectories(`value`: Output<List<ActiveDirectoryArgs>>) {
        this.activeDirectories = value
    }

    @JvmName("jphgeyywnbjfotcg")
    public suspend fun activeDirectories(vararg values: Output<ActiveDirectoryArgs>) {
        this.activeDirectories = Output.all(values.asList())
    }

    /**
     * @param values Active Directories
     */
    @JvmName("kbogwepkpmghgcck")
    public suspend fun activeDirectories(values: List<Output<ActiveDirectoryArgs>>) {
        this.activeDirectories = Output.all(values)
    }

    /**
     * @param value Encryption settings
     */
    @JvmName("vfyjvchyafjigvlj")
    public suspend fun encryption(`value`: Output<AccountEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identity used for the resource.
     */
    @JvmName("lpvgqhsowqhwjvlf")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xksanqmmscbfoaxu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ftnggrrxhnldhcxs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rxwjrhmfoeldxmqu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("rkbtkcjdmmfdcsyo")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Active Directories
     */
    @JvmName("wwdiyakwwpknwbii")
    public suspend fun activeDirectories(`value`: List<ActiveDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectories = mapped
    }

    /**
     * @param argument Active Directories
     */
    @JvmName("dqfydtyurpqoocuk")
    public suspend
    fun activeDirectories(argument: List<suspend ActiveDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActiveDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activeDirectories = mapped
    }

    /**
     * @param argument Active Directories
     */
    @JvmName("lnvaltderjxxhtjc")
    public suspend fun activeDirectories(
        vararg
        argument: suspend ActiveDirectoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ActiveDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activeDirectories = mapped
    }

    /**
     * @param argument Active Directories
     */
    @JvmName("kytaccxgudtmfoch")
    public suspend fun activeDirectories(argument: suspend ActiveDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActiveDirectoryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.activeDirectories = mapped
    }

    /**
     * @param values Active Directories
     */
    @JvmName("cdbhmxbugrvoopud")
    public suspend fun activeDirectories(vararg values: ActiveDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeDirectories = mapped
    }

    /**
     * @param value Encryption settings
     */
    @JvmName("vkeohenkgtbwpmab")
    public suspend fun encryption(`value`: AccountEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption settings
     */
    @JvmName("qsdfycyrrqliglyv")
    public suspend fun encryption(argument: suspend AccountEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = AccountEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identity used for the resource.
     */
    @JvmName("vcnykswdmibipqgf")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity used for the resource.
     */
    @JvmName("yoyakwoelnfwdhth")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("oauiasucjungcyox")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xqykvvtdjelowxxi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ymtqhipcvbmbcksq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rxgpxhahxdmjexyn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        activeDirectories = activeDirectories,
        encryption = encryption,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
