@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Snapshot of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-06-01, 2019-10-01, 2019-11-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
 * ## Example Usage
 * ### Snapshots_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.NetApp.Snapshot("snapshot", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         SnapshotName = "snapshot1",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSnapshot(ctx, "snapshot", &netapp.SnapshotArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			SnapshotName:      pulumi.String("snapshot1"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Snapshot;
 * import com.pulumi.azurenative.netapp.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .snapshotName("snapshot1")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Snapshot account1/pool1/volume1/snapshot1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}
 * ```
 * @property accountName The name of the NetApp account
 * @property location Resource location
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotName The name of the snapshot
 * @property volumeName The name of the volume
 */
public data class SnapshotArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.SnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.SnapshotArgs =
        com.pulumi.azurenative.netapp.SnapshotArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var snapshotName: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("vwsunjmrxrikcxjp")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("lyfknphjpngqmdhu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("tcmdcfckyuvovbxw")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("avvrkgyqtrbvdixg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the snapshot
     */
    @JvmName("sckboyvylifdwsgj")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("lisuossdtgincjwn")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("xuqkughdiwrktcuv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("jchqhvcutgxgyfjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("mrxybjlestqgnnbc")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rmlypymlhbnubpwf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the snapshot
     */
    @JvmName("avdftunwbocdglhg")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("ybjqldljskijyekf")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        accountName = accountName,
        location = location,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        snapshotName = snapshotName,
        volumeName = volumeName,
    )
}
